-- ========================================
-- Co-op Supermarkets - South West England
-- Preload Data for Risk Assessment System
-- ========================================

USE risk_assessment_db;

-- Devon Stores
INSERT INTO locations (name, chain, address, city, postcode, latitude, longitude, what3words, opening_hours, delivery_windows, contact_name, contact_phone, contact_email, parking_info, delivery_restrictions, special_instructions, active) VALUES

('Co-op Plymouth City Centre', 'Co-op', '156-158 Armada Way', 'Plymouth', 'PL1 1HX', 50.3755, -4.1427, 'punch.faster.spoon',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"11:00","name":"Morning"}],"sunday":[]}',
'Sarah Mitchell', '01752 123456', 'plymouth.city@coop.co.uk',
'Loading bay at rear of building, access via Drake Circus. Height restriction 4.2m. Multi-story car park nearby for deliveries.',
'Maximum vehicle length 7.5m. No HGV access before 7am or after 6pm Monday-Saturday. Sunday deliveries by arrangement only.',
'Use pedestrian entrance on Armada Way for trolley access. Building security code required - contact store manager.',
1),

('Co-op Exeter High Street', 'Co-op', '245 High Street', 'Exeter', 'EX4 3NZ', 50.7236, -3.5275, 'stamps.deeply.winks',
'{"monday":{"open":"07:00","close":"23:00","closed":false},"tuesday":{"open":"07:00","close":"23:00","closed":false},"wednesday":{"open":"07:00","close":"23:00","closed":false},"thursday":{"open":"07:00","close":"23:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"08:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"13:00","end":"17:00","name":"Afternoon"}],"tuesday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"13:00","end":"17:00","name":"Afternoon"}],"wednesday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"13:00","end":"17:00","name":"Afternoon"}],"thursday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"13:00","end":"17:00","name":"Afternoon"}],"friday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"13:00","end":"17:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'James Parker', '01392 234567', 'exeter.high@coop.co.uk',
'Limited street parking. Loading bay on Sidwell Street, 50m walk. Double yellow lines - loading permit required.',
'City centre restrictions apply. HGV deliveries 5:30am-9:30am only. Maximum 30-minute parking in loading bay.',
'Contact store 30 minutes before arrival. Store manager must be present for large deliveries.',
1),

('Co-op Torquay Harbour', 'Co-op', '12 The Strand', 'Torquay', 'TQ1 2AA', 50.4619, -3.5253, 'slopes.dined.shark',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"08:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"17:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"17:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"17:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"17:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Emma Wilson', '01803 345678', 'torquay.harbour@coop.co.uk',
'Rear access via Victoria Parade. Steep slope - use low gear. On-street parking permit zone.',
'Narrow access road. Maximum vehicle width 2.5m. Deliveries before 10am to avoid tourist traffic.',
'Challenging access in summer months. Book delivery slot minimum 48 hours in advance.',
1),

('Co-op Barnstaple High Street', 'Co-op', '78 High Street', 'Barnstaple', 'EX31 1HZ', 51.0803, -4.0579, 'laptop.salads.grins',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"20:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'David Thomas', '01271 456789', 'barnstaple@coop.co.uk',
'Loading bay behind store, access via Bear Street. Public car park 100m away.',
'Standard HGV access. Height restriction 4.5m under archway. No oversized vehicles.',
'Call ahead during Barnstaple Fair week (September) - access may be restricted.',
1),

-- Cornwall Stores
('Co-op Truro City Centre', 'Co-op', '34 Boscawen Street', 'Truro', 'TR1 2QU', 50.2632, -5.0510, 'panels.brings.rushed',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Rachel Davies', '01872 567890', 'truro.centre@coop.co.uk',
'Side entrance on St Nicholas Street. Loading bay available. Pay and display parking nearby.',
'City centre location - tight access. Maximum vehicle length 9m. Weekend deliveries restricted.',
'Cathedral traffic restrictions apply during services. Check with store before Sunday deliveries.',
1),

('Co-op Penzance Market Place', 'Co-op', '15 Market Place', 'Penzance', 'TR18 2JB', 50.1186, -5.5371, 'jumps.string.posted',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"09:30","name":"Morning"},{"start":"14:00","end":"17:30","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"09:30","name":"Morning"},{"start":"14:00","end":"17:30","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"09:30","name":"Morning"},{"start":"14:00","end":"17:30","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"09:30","name":"Morning"}],"friday":[{"start":"06:00","end":"09:30","name":"Morning"},{"start":"14:00","end":"17:30","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"09:00","name":"Early"}],"sunday":[]}',
'Tom Richardson', '01736 678901', 'penzance@coop.co.uk',
'Rear access from Alverton Street car park. Narrow lane - proceed with caution.',
'Market day (Thursday) - no deliveries 8am-5pm. Coastal winds - secure all loads. Max vehicle width 2.3m.',
'Thursday market day means alternative delivery day required. Friday preferred.',
1),

('Co-op Newquay Town Centre', 'Co-op', '67 Fore Street', 'Newquay', 'TR7 1HA', 50.4120, -5.0757, 'grapes.dined.pulled',
'{"monday":{"open":"07:00","close":"23:00","closed":false},"tuesday":{"open":"07:00","close":"23:00","closed":false},"wednesday":{"open":"07:00","close":"23:00","closed":false},"thursday":{"open":"07:00","close":"23:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"07:00","close":"23:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"}],"saturday":[{"start":"06:00","end":"09:00","name":"Early"}],"sunday":[]}',
'Lucy Bennett', '01637 789012', 'newquay@coop.co.uk',
'Loading at rear via Beach Road. Very limited space. Summer traffic congestion severe.',
'SUMMER ONLY: Deliveries before 9am essential. No deliveries during school holidays 9am-6pm. Tourist traffic extreme.',
'Book summer deliveries 1 week in advance. Consider winter months for major deliveries.',
1),

('Co-op Falmouth Docks', 'Co-op', '23 Discovery Quay', 'Falmouth', 'TR11 3XZ', 50.1504, -5.0670, 'dating.gifted.hotels',
'{"monday":{"open":"06:00","close":"23:00","closed":false},"tuesday":{"open":"06:00","close":"23:00","closed":false},"wednesday":{"open":"06:00","close":"23:00","closed":false},"thursday":{"open":"06:00","close":"23:00","closed":false},"friday":{"open":"06:00","close":"23:00","closed":false},"saturday":{"open":"06:00","close":"23:00","closed":false},"sunday":{"open":"07:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"05:00","end":"09:00","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"05:00","end":"09:00","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"05:00","end":"09:00","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"05:00","end":"09:00","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"05:00","end":"09:00","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"05:00","end":"09:00","name":"Early"}],"sunday":[]}',
'Michael Stevens', '01326 890123', 'falmouth.docks@coop.co.uk',
'Docks area - excellent HGV access via Port Road. Large loading bay. Ample parking.',
'Working port - follow maritime traffic rules. High winds may close port. Cruise ship days (summer) - expect delays.',
'Port security clearance required for first visit. Contact store 24hrs ahead for access pass.',
1),

('Co-op St Austell Bay', 'Co-op', '89 Fore Street', 'St Austell', 'PL25 5PX', 50.3418, -4.7884, 'punks.eating.handed',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Helen Morris', '01726 901234', 'staustell@coop.co.uk',
'Rear access via South Street. Standard loading bay. Street parking available.',
'Standard access. No specific restrictions. China clay lorries may cause delays on A390.',
'Town centre location - straightforward access. Contact for any special requirements.',
1),

-- Somerset Stores
('Co-op Taunton East Reach', 'Co-op', '45 East Reach', 'Taunton', 'TA1 3ES', 51.0150, -3.1006, 'spends.tribal.gravel',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Andrew Collins', '01823 012345', 'taunton.east@coop.co.uk',
'Loading bay on Station Road. Good access. NCP car park adjacent for parking.',
'County town - market days (Tue/Thu/Sat) may cause delays. Standard HGV access.',
'Market day deliveries best before 8am. Contact store for preferred delivery times.',
1),

('Co-op Bath Walcot Street', 'Co-op', '156 Walcot Street', 'Bath', 'BA1 5BG', 51.3890, -2.3547, 'trains.simple.divide',
'{"monday":{"open":"07:00","close":"23:00","closed":false},"tuesday":{"open":"07:00","close":"23:00","closed":false},"wednesday":{"open":"07:00","close":"23:00","closed":false},"thursday":{"open":"07:00","close":"23:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"08:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"05:30","end":"09:00","name":"Early Morning"}],"tuesday":[{"start":"05:30","end":"09:00","name":"Early Morning"}],"wednesday":[{"start":"05:30","end":"09:00","name":"Early Morning"}],"thursday":[{"start":"05:30","end":"09:00","name":"Early Morning"}],"friday":[{"start":"05:30","end":"09:00","name":"Early Morning"}],"saturday":[{"start":"05:30","end":"08:30","name":"Early"}],"sunday":[]}',
'Sophie Turner', '01225 123456', 'bath.walcot@coop.co.uk',
'UNESCO World Heritage Site - special restrictions apply. Loading bay on London Road. Very limited access.',
'CRITICAL: Early morning deliveries ONLY (before 9am). Heritage area restrictions. Maximum vehicle length 7.5m. Bath Clean Air Zone charges apply.',
'Heritage site - advance booking essential. Tourist traffic extremely heavy. Winter deliveries preferred.',
1),

('Co-op Yeovil Middle Street', 'Co-op', '78 Middle Street', 'Yeovil', 'BA20 1LY', 50.9442, -2.6325, 'shades.tigers.pocket',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Robert Hughes', '01935 234567', 'yeovil@coop.co.uk',
'Rear access from Dampier Street. Standard loading facilities. Public parking nearby.',
'Market town - Friday market day. Good access otherwise. Standard HGV acceptable.',
'Straightforward deliveries. Friday before 7am preferred due to market.',
1),

('Co-op Bridgwater Fore Street', 'Co-op', '92 Fore Street', 'Bridgwater', 'TA6 3LP', 51.1278, -2.9930, 'hardly.prizes.rested',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Jennifer White', '01278 345678', 'bridgwater@coop.co.uk',
'Loading via Blake Place. Adequate space. Town centre parking available.',
'Standard access. Carnival week (November) - extreme restrictions. Book well in advance.',
'Bridgwater Carnival week requires special arrangements - contact early.',
1),

('Co-op Weston-super-Mare Regent Street', 'Co-op', '134 Regent Street', 'Weston-super-Mare', 'BS23 1SJ', 51.3463, -2.9761, 'cheers.dotted.riches',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"08:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Mark Anderson', '01934 456789', 'weston@coop.co.uk',
'Rear access from Oxford Street. Seaside location - summer congestion severe.',
'SUMMER SEASON: Deliveries before 9am essential. Tourist town - bank holidays very busy. Seafront traffic restrictions.',
'Avoid summer weekends if possible. Early morning deliveries strongly preferred May-September.',
1);

-- Continue with more stores...
-- (Output continues with Dorset, Gloucestershire, Wiltshire, and Bristol stores)

SELECT 'Co-op stores loaded successfully!' as Status, COUNT(*) as Stores_Added FROM locations WHERE chain = 'Co-op';

-- Dorset Stores
INSERT INTO locations (name, chain, address, city, postcode, latitude, longitude, what3words, opening_hours, delivery_windows, contact_name, contact_phone, contact_email, parking_info, delivery_restrictions, special_instructions, active) VALUES

('Co-op Bournemouth Old Christchurch Road', 'Co-op', '467 Old Christchurch Road', 'Bournemouth', 'BH1 4AP', 50.7260, -1.8578, 'chops.soften.daring',
'{"monday":{"open":"07:00","close":"23:00","closed":false},"tuesday":{"open":"07:00","close":"23:00","closed":false},"wednesday":{"open":"07:00","close":"23:00","closed":false},"thursday":{"open":"07:00","close":"23:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"07:00","close":"23:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Lisa Campbell', '01202 567890', 'bournemouth.oldx@coop.co.uk',
'Side access via Cranborne Road. Busy student area. Limited parking - use meter bays.',
'University area - student term times very busy. Evening deliveries difficult. Parking enforcement strict.',
'Term time (Oct-May) - early morning only. Summer easier but tourist traffic increases.',
1),

('Co-op Poole High Street', 'Co-op', '189 High Street', 'Poole', 'BH15 1AU', 50.7143, -1.9871, 'rushed.bliss.cobras',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Karen Edwards', '01202 678901', 'poole.high@coop.co.uk',
'Rear loading from Market Street. Town centre location. Dolphin Centre parking nearby.',
'Retail park nearby - coordinated delivery slots available. Standard town centre access.',
'Good access. Coordinate with Dolphin Centre deliveries for efficiency.',
1),

('Co-op Weymouth St Thomas Street', 'Co-op', '56 St Thomas Street', 'Weymouth', 'DT4 8EQ', 50.6097, -2.4548, 'tones.widget.rushed',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"17:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"17:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"17:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"17:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"}],"saturday":[{"start":"06:00","end":"09:00","name":"Early"}],"sunday":[]}',
'Peter Walsh', '01305 789012', 'weymouth@coop.co.uk',
'Loading via Hope Street. Seaside resort - summer tourist traffic extreme. Ferry port nearby.',
'SUMMER CRITICAL: Before 9am only June-August. Ferry traffic Wed/Sun. Tourist congestion severe.',
'Avoid summer completely if possible. Ferry days cause additional delays. Winter much easier.',
1),

('Co-op Dorchester South Street', 'Co-op', '28 South Street', 'Dorchester', 'DT1 1BZ', 50.7152, -2.4372, 'lungs.voting.awards',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Amanda Foster', '01305 890123', 'dorchester@coop.co.uk',
'Rear access from Trinity Street. County town - market Wednesday. Parking meters.',
'Wednesday market day - NO deliveries 8am-4pm. Otherwise good access. Historic town centre.',
'Market day alternative required. Thursday morning preferred alternative slot.',
1),

-- Gloucestershire Stores
('Co-op Gloucester Eastgate Street', 'Co-op', '112 Eastgate Street', 'Gloucester', 'GL1 1PY', 51.8656, -2.2478, 'papers.gravel.shades',
'{"monday":{"open":"07:00","close":"23:00","closed":false},"tuesday":{"open":"07:00","close":"23:00","closed":false},"wednesday":{"open":"07:00","close":"23:00","closed":false},"thursday":{"open":"07:00","close":"23:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"08:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"05:30","end":"09:30","name":"Morning"}],"sunday":[]}',
'Graham Baker', '01452 901234', 'gloucester.eastgate@coop.co.uk',
'Loading via Longsmith Street. Cathedral city - some restricted areas. Good facilities.',
'City centre location. Cathedral events may cause diversions. Generally good access.',
'Well-organized city. Contact for major religious festivals as access may vary.',
1),

('Co-op Cheltenham High Street', 'Co-op', '267 High Street', 'Cheltenham', 'GL50 3HW', 51.8997, -2.0763, 'simple.trusts.dating',
'{"monday":{"open":"07:00","close":"23:00","closed":false},"tuesday":{"open":"07:00","close":"23:00","closed":false},"wednesday":{"open":"07:00","close":"23:00","closed":false},"thursday":{"open":"07:00","close":"23:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"08:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"05:30","end":"09:30","name":"Early Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"05:30","end":"09:00","name":"Early"}],"sunday":[]}',
'Victoria Price', '01242 012345', 'cheltenham.high@coop.co.uk',
'Access via Bennington Street. Spa town - festival periods very busy (March, July, October).',
'FESTIVALS: Cheltenham Festivals cause major disruptions. Book months ahead for festival weeks. Gold Cup week (March) - avoid completely.',
'Festival town - check calendar before scheduling. Race weeks impossible for deliveries.',
1),

('Co-op Stroud High Street', 'Co-op', '45 High Street', 'Stroud', 'GL5 1AP', 51.7450, -2.2197, 'shiny.grins.driver',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Simon Clark', '01453 123456', 'stroud@coop.co.uk',
'Hillside town - steep approaches. Loading via King Street. Farmers market Saturday.',
'STEEP HILLS - low gear essential. Saturday market day. Victorian mill town - narrow streets.',
'Challenging terrain. Saturday before 7am essential. Experienced drivers recommended.',
1),

-- Wiltshire Stores
('Co-op Swindon Regent Street', 'Co-op', '89 Regent Street', 'Swindon', 'SN1 1JQ', 51.5558, -1.7797, 'pulled.things.driven',
'{"monday":{"open":"07:00","close":"23:00","closed":false},"tuesday":{"open":"07:00","close":"23:00","closed":false},"wednesday":{"open":"07:00","close":"23:00","closed":false},"thursday":{"open":"07:00","close":"23:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"08:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Daniel Wright', '01793 234567', 'swindon.regent@coop.co.uk',
'Rear access from Fleet Street. Town centre regeneration - follow diversion signs. Modern loading bay.',
'Major town - good infrastructure. Town centre improvements ongoing. Follow current signage.',
'Straightforward deliveries. Check for any roadworks updates before departure.',
1),

('Co-op Salisbury Castle Street', 'Co-op', '67 Castle Street', 'Salisbury', 'SP1 1BB', 51.0693, -1.7944, 'chops.glove.nobles',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"05:30","end":"09:00","name":"Early Morning"}],"tuesday":[{"start":"05:30","end":"09:00","name":"Early Morning"}],"wednesday":[{"start":"05:30","end":"09:00","name":"Early Morning"}],"thursday":[{"start":"05:30","end":"09:00","name":"Early Morning"}],"friday":[{"start":"05:30","end":"09:00","name":"Early Morning"}],"saturday":[{"start":"05:30","end":"08:30","name":"Early"}],"sunday":[]}',
'Rebecca Morgan', '01722 345678', 'salisbury.castle@coop.co.uk',
'Historic city centre - delivery restrictions severe. Loading from New Street ONLY. Cathedral Quarter.',
'HISTORIC SITE: Medieval street layout. Very narrow access. Maximum 7.5t vehicle. Before 9am MANDATORY.',
'One of most restricted sites. Advanced driver skills essential. Cathedral events cause closures.',
1),

('Co-op Chippenham Market Place', 'Co-op', '34 Market Place', 'Chippenham', 'SN15 3HP', 51.4584, -2.1169, 'clouds.driven.cobras',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Catherine Lewis', '01249 456789', 'chippenham@coop.co.uk',
'Market Place location - Friday market prohibits deliveries. Access via Bridge Street.',
'FRIDAY: NO DELIVERIES - Market day all day. Monday-Thursday good access. Saturday before 10am.',
'Friday alternative day essential. Historic market town - respect market traditions.',
1),

-- Bristol Stores
('Co-op Bristol Park Street', 'Co-op', '145 Park Street', 'Bristol', 'BS1 5TJ', 51.4555, -2.6044, 'caring.dined.crunch',
'{"monday":{"open":"06:00","close":"midnight","closed":false},"tuesday":{"open":"06:00","close":"midnight","closed":false},"wednesday":{"open":"06:00","close":"midnight","closed":false},"thursday":{"open":"06:00","close":"midnight","closed":false},"friday":{"open":"06:00","close":"midnight","closed":false},"saturday":{"open":"06:00","close":"midnight","closed":false},"sunday":{"open":"07:00","close":"23:00","closed":false}}',
'{"monday":[{"start":"05:00","end":"09:00","name":"Early Morning"}],"tuesday":[{"start":"05:00","end":"09:00","name":"Early Morning"}],"wednesday":[{"start":"05:00","end":"09:00","name":"Early Morning"}],"thursday":[{"start":"05:00","end":"09:00","name":"Early Morning"}],"friday":[{"start":"05:00","end":"09:00","name":"Early Morning"}],"saturday":[{"start":"05:00","end":"08:30","name":"Early"}],"sunday":[]}',
'Oliver Martin', '0117 923 4567', 'bristol.park@coop.co.uk',
'STEEP HILL WARNING: 1 in 10 gradient. Low gear essential. Loading via Berkeley Square. Park Street is Bristol''s steepest shopping street.',
'CRITICAL: Very steep hill - experienced drivers only. Early morning only (before 9am). No deliveries in icy conditions. Clean Air Zone charges apply.',
'One of steepest retail streets in UK. Driver briefing essential. Winter gritting priority route.',
1),

('Co-op Bristol Gloucester Road', 'Co-op', '267 Gloucester Road', 'Bristol', 'BS7 8NY', 51.4774, -2.5839, 'softer.relate.python',
'{"monday":{"open":"07:00","close":"23:00","closed":false},"tuesday":{"open":"07:00","close":"23:00","closed":false},"wednesday":{"open":"07:00","close":"23:00","closed":false},"thursday":{"open":"07:00","close":"23:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"08:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Hannah Scott', '0117 942 5678', 'bristol.glos@coop.co.uk',
'Bristol''s longest independent shopping street. Loading from rear via Sommerville Road. Student area.',
'Busy shopping street. Student area - term times busier. Clean Air Zone applies. Standard urban access.',
'Popular street. Coordinate with other deliveries in area for efficiency.',
1),

('Co-op Bristol Clifton Village', 'Co-op', '89 Princess Victoria Street', 'Bristol', 'BS8 4DD', 51.4624, -2.6200, 'relate.awards.dreams',
'{"monday":{"open":"07:00","close":"22:00","closed":false},"tuesday":{"open":"07:00","close":"22:00","closed":false},"wednesday":{"open":"07:00","close":"22:00","closed":false},"thursday":{"open":"07:00","close":"22:00","closed":false},"friday":{"open":"07:00","close":"22:00","closed":false},"saturday":{"open":"07:00","close":"22:00","closed":false},"sunday":{"open":"08:00","close":"21:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"09:30","name":"Early Morning"}],"tuesday":[{"start":"06:00","end":"09:30","name":"Early Morning"}],"wednesday":[{"start":"06:00","end":"09:30","name":"Early Morning"}],"thursday":[{"start":"06:00","end":"09:30","name":"Early Morning"}],"friday":[{"start":"06:00","end":"09:30","name":"Early Morning"}],"saturday":[{"start":"06:00","end":"09:00","name":"Early"}],"sunday":[]}',
'Thomas Hill', '0117 973 6789', 'bristol.clifton@coop.co.uk',
'Exclusive residential area - strict access controls. Loading from service road. Resident parking only.',
'PREMIUM AREA: Resident parking restrictions very strict. Before 9:30am essential. Suspension Bridge traffic. Affluent area - quiet deliveries required.',
'Challenging location. Suspension Bridge nearby - tourist traffic. Early deliveries minimize disruption.',
1),

('Co-op Bristol Whiteladies Road', 'Co-op', '178 Whiteladies Road', 'Bristol', 'BS8 2XU', 51.4654, -2.6122, 'gravel.dating.punks',
'{"monday":{"open":"07:00","close":"23:00","closed":false},"tuesday":{"open":"07:00","close":"23:00","closed":false},"wednesday":{"open":"07:00","close":"23:00","closed":false},"thursday":{"open":"07:00","close":"23:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"08:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Sarah Johnson', '0117 973 7890', 'bristol.whiteladies@coop.co.uk',
'Major shopping street. Side access from Apsley Road. BBC Bristol nearby - media traffic.',
'Popular shopping area. BBC and University nearby. Good access. Clean Air Zone charges.',
'Well-established delivery route. Good coordination with other suppliers.',
1),

('Co-op Bristol Harbourside', 'Co-op', '45 Wapping Wharf', 'Bristol', 'BS1 6UA', 51.4479, -2.6003, 'grapes.rushed.spoken',
'{"monday":{"open":"07:00","close":"23:00","closed":false},"tuesday":{"open":"07:00","close":"23:00","closed":false},"wednesday":{"open":"07:00","close":"23:00","closed":false},"thursday":{"open":"07:00","close":"23:00","closed":false},"friday":{"open":"07:00","close":"23:00","closed":false},"saturday":{"open":"07:00","close":"23:00","closed":false},"sunday":{"open":"08:00","close":"22:00","closed":false}}',
'{"monday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"tuesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"wednesday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"thursday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"friday":[{"start":"06:00","end":"10:00","name":"Morning"},{"start":"14:00","end":"18:00","name":"Afternoon"}],"saturday":[{"start":"06:00","end":"10:00","name":"Morning"}],"sunday":[]}',
'Marcus Brown', '0117 925 8901', 'bristol.harbour@coop.co.uk',
'Regenerated dockside area. Modern development - good access. Harbourside pedestrian area nearby.',
'Modern facility. Weekend tourist area. Balloon Fiesta week (August) - major restrictions. Good year-round access.',
'New development - excellent facilities. Check for harbourside events before delivery.',
1);

-- Summary query
SELECT 
    'South West England Co-op Stores Successfully Loaded!' as Status,
    COUNT(*) as Total_Stores,
    COUNT(DISTINCT city) as Cities_Covered,
    'Devon, Cornwall, Somerset, Dorset, Gloucestershire, Wiltshire, Bristol' as Counties
FROM locations 
WHERE chain = 'Co-op';

-- Show store counts by county
SELECT 
    CASE 
        WHEN city IN ('Plymouth', 'Exeter', 'Torquay', 'Barnstaple') THEN 'Devon'
        WHEN city IN ('Truro', 'Penzance', 'Newquay', 'Falmouth', 'St Austell') THEN 'Cornwall'
        WHEN city IN ('Taunton', 'Bath', 'Yeovil', 'Bridgwater', 'Weston-super-Mare') THEN 'Somerset'
        WHEN city IN ('Bournemouth', 'Poole', 'Weymouth', 'Dorchester') THEN 'Dorset'
        WHEN city IN ('Gloucester', 'Cheltenham', 'Stroud') THEN 'Gloucestershire'
        WHEN city IN ('Swindon', 'Salisbury', 'Chippenham') THEN 'Wiltshire'
        WHEN city = 'Bristol' THEN 'Bristol'
        ELSE 'Other'
    END as County,
    COUNT(*) as Store_Count
FROM locations 
WHERE chain = 'Co-op'
GROUP BY County
ORDER BY Store_Count DESC;
