# Database Directory
## Risk Assessment System v3.4.5

---

## 📁 Current Files

### Primary Schema
- **schema_master.sql** (33KB) - PRIMARY SCHEMA FILE
  - All 26 tables defined
  - Use this for new installations
  
- **complete_schema.sql** (33KB) - SAME AS ABOVE
  - Kept for compatibility
  - Identical to schema_master.sql

### Data Files
- **coop_stores_southwest.sql** (45KB)
  - 30 Co-op supermarket locations
  - South West England coverage
  - Load after schema installation

### Migration Files
- **fix_missing_columns.sql** (1.2KB)
  - Adds: visit_time, description, is_locked, hazard_name, location_area
  - For upgrading from v3.4.2 or earlier
  
- **photo_upload_fix.sql** (531 bytes)
  - Adds: photos column to assessment_risks
  - For upgrading from v3.4.1 or earlier

### Archive
- **_archive_old_schemas/** (directory)
  - Old schema files (12 files)
  - Kept for reference only
  - DO NOT USE

---

## 🚀 Quick Start

### New Installation

```bash
# Create database
mysql -u root -p -e "CREATE DATABASE risk_assessment_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"

# Load schema
mysql -u root -p risk_assessment_db < schema_master.sql

# Verify (should show 26 tables)
mysql -u root -p risk_assessment_db -e "SHOW TABLES;"

# Optional: Load Co-op stores data
mysql -u root -p risk_assessment_db < coop_stores_southwest.sql
```

### Upgrading Existing Installation

```bash
# From v3.4.2 or earlier - add missing columns
mysql -u root -p risk_assessment_db < fix_missing_columns.sql

# From v3.4.1 or earlier - add photo support
mysql -u root -p risk_assessment_db < photo_upload_fix.sql

# Verify tables
mysql -u root -p risk_assessment_db -e "SHOW TABLES;" | wc -l
# Should output: 27 (26 tables + header)
```

---

## 📊 Database Structure

### 26 Tables

**Core (4):**
- users
- locations
- assessments
- assessment_risks

**Risk Library (4):**
- risk_categories
- risk_items
- control_measures
- hazard_library_photos

**Workflow (3):**
- action_items
- assessment_versions
- change_requests

**Location Features (2):**
- location_hours
- delivery_slots

**Audit (3):**
- audit_log
- user_activity
- retention_policies

**Customization (5):**
- color_themes
- user_preferences
- pdf_templates
- custom_fields
- custom_field_values

**System (5):**
- permissions
- system_settings
- email_queue
- sessions
- sync_queue

---

## ✅ Verification

### Check All Tables Exist

```sql
SELECT COUNT(*) FROM information_schema.tables 
WHERE table_schema = 'risk_assessment_db';
```
Expected: 26

### Check Specific Table

```sql
DESCRIBE users;
```

Should show: password (NOT password_hash)

### Check All Table Names

```sql
SHOW TABLES;
```

Should list all 26 tables alphabetically.

---

## 🔄 Migration History

- **v3.4.1** - Base schema (20 tables)
- **v3.4.2** - Added photo support
- **v3.4.3** - Added missing columns
- **v3.4.4** - Navigation fixes (no schema changes)
- **v3.4.5** - Schema consolidation (26 tables)

---

## 📝 Notes

- **schema_master.sql** is the authoritative source
- **complete_schema.sql** is kept for backwards compatibility
- Both files are identical
- Use migrations for existing databases
- Fresh installations should use schema_master.sql
- Archive folder contains old files for reference only

---

**Version:** 3.4.5  
**Tables:** 26  
**Status:** Production Ready  
**Last Updated:** February 2026
