<?php
/**
 * Risk Assessment System - Configuration
 * Version: 2.2.0
 */

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'scubatricky_risk');
define('DB_USER', 'scubatricky_risk');
define('DB_PASS', 'Cooperative1234!');
define('DB_CHARSET', 'utf8mb4');

// Environment Configuration
define('ENVIRONMENT', 'production'); // Options: 'development', 'production'

// Error Reporting Configuration
if (ENVIRONMENT === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
} else {
    error_reporting(E_ALL & ~E_DEPRECATED);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', __DIR__ . '/../logs/php_errors.log');
}

// Application Settings
define('APP_NAME', 'Risk Assessment System');
define('APP_VERSION', '3.5.0');

// Dynamic Site URL - works in any environment
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
$scriptName = $_SERVER['SCRIPT_NAME'] ?? '';
$basePath = rtrim(str_replace('/public', '', dirname($scriptName)), '/');
define('BASE_URL', $protocol . '://' . $host . $basePath);
define('SITE_URL', BASE_URL . '/public/');

// Path Settings
define('ROOT_PATH', dirname(__DIR__));
define('INCLUDES_PATH', ROOT_PATH . '/includes');
define('UPLOADS_PATH', ROOT_PATH . '/uploads');
define('LOGS_PATH', ROOT_PATH . '/logs');

// Security Settings
define('SESSION_LIFETIME', 3600); // 1 hour
define('PASSWORD_MIN_LENGTH', 8);
define('HASH_ALGO', PASSWORD_DEFAULT);

// File Upload Settings
define('MAX_UPLOAD_SIZE', 10485760); // 10MB
define('ALLOWED_EXTENSIONS', ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'jpg', 'jpeg', 'png']);

// Pagination
define('ITEMS_PER_PAGE', 20);

// Email Configuration
define('SMTP_FROM', 'noreply@yourdomain.com');
define('SMTP_FROM_NAME', APP_NAME);
define('ENABLE_EMAIL_NOTIFICATIONS', true);

// Timezone
date_default_timezone_set('UTC');

// Session Configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 1); // Set to 1 if using HTTPS

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Create necessary directories
$directories = [UPLOADS_PATH, LOGS_PATH];
foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        mkdir($dir, 0755, true);
    }
}
