#!/bin/bash

# Risk Assessment System - Complete Build Script
# This script creates all necessary files for the system

set -e

BASE_DIR="/home/claude/risk-assessment-system-v3"
cd "$BASE_DIR"

echo "Building Risk Assessment System v3.0..."
echo "========================================"

# Copy documentation
echo "Copying documentation..."
cp /mnt/project/README.md .
cp /mnt/project/OFFLINE_AND_PDF_GUIDE.md .
cp /mnt/project/PHOTO_ATTACHMENTS_GUIDE.md .

echo "Build script complete!"
echo "Next steps:"
echo "1. Update database credentials in config/config.php"
echo "2. Import database/schema.sql"
echo "3. Set proper permissions"
echo "4. Access via web browser"
