#!/bin/bash

echo "=========================================="
echo "Risk Assessment System - Verification"
echo "=========================================="
echo ""

# Check directory structure
echo "1. Checking directory structure..."
if [ -d "public/assets/css" ]; then
    echo "   ✓ public/assets/css exists"
else
    echo "   ✗ public/assets/css NOT FOUND!"
fi

if [ -f "public/assets/css/style.css" ]; then
    SIZE=$(wc -c < public/assets/css/style.css)
    echo "   ✓ style.css exists ($SIZE bytes)"
else
    echo "   ✗ style.css NOT FOUND!"
fi

if [ -f "public/locations.php" ]; then
    echo "   ✓ locations.php exists"
else
    echo "   ✗ locations.php NOT FOUND!"
fi

# Check header.php
echo ""
echo "2. Checking header.php navigation..."
if grep -q 'href="<?php echo SITE_URL; ?>locations.php"' includes/header.php; then
    echo "   ✓ Locations link found in header.php"
else
    echo "   ✗ Locations link NOT FOUND in header.php!"
fi

# Check for broken HTML
echo ""
echo "3. Checking for nested links..."
if grep -q '<a.*<a' includes/header.php; then
    echo "   ✗ WARNING: Nested links detected!"
else
    echo "   ✓ No nested links found"
fi

# Check permissions
echo ""
echo "4. Checking file permissions..."
ls -l public/locations.php | awk '{print "   " $1, $9}'
ls -l public/assets/css/style.css | awk '{print "   " $1, $9}'

echo ""
echo "=========================================="
echo "Verification complete!"
echo "=========================================="
echo ""
echo "Test URLs to visit:"
echo "  • /public/nav-test-static.html"
echo "  • /public/test-locations-link.html"
echo "  • /public/locations.php (after login)"
echo ""
