# Risk Assessment System v3.4.0 - Quick Installation Guide

## 🚀 5-Minute Installation

### Step 1: Extract Files (30 seconds)
```bash
cd /var/www/html
tar -xzf risk-assessment-v3.4-complete.tar.gz
cd risk-assessment-modern-v3
```

### Step 2: Database Setup (1 minute)
```bash
# One command - imports everything!
mysql -u root -p < database/complete_schema.sql
```

That's it! The complete_schema.sql file:
- ✅ Creates the database
- ✅ Creates all 23 tables
- ✅ Sets up all foreign keys and indexes
- ✅ Adds default admin user
- ✅ Loads sample hazards
- ✅ Configures permissions
- ✅ Sets retention policies
- ✅ Ready to use!

### Step 3: Configure (1 minute)
```bash
nano config/config.php
```

Update only 4 lines:
```php
define('DB_HOST', 'localhost');        // Your MySQL host
define('DB_NAME', 'risk_assessment_db');  // Keep this
define('DB_USER', 'your_username');    // Your MySQL user
define('DB_PASS', 'your_password');    // Your MySQL password
```

### Step 4: Set Permissions (30 seconds)
```bash
bash QUICK_FIX.sh
```

This automatically:
- Sets correct file permissions
- Creates upload directories
- Tests database connection
- Verifies setup

### Step 5: Access System (30 seconds)
```
URL: http://yourdomain.com/public/login.php
Username: admin
Password: admin123
```

⚠️ **Change the admin password immediately!**

---

## ✅ Verify Installation

### Run System Checker
```
http://yourdomain.com/SYSTEM_CHECKER.php
```

Expected: **100% tests passed**

If any tests fail:
1. Check error message
2. Run `bash QUICK_FIX.sh` again
3. Review logs: `tail -f logs/php_errors.log`

---

## 📊 What You Get

After installation, you'll have:

### Users
- ✅ Admin user (admin/admin123)
- Can add more users from Users menu

### Sample Data
- ✅ 10 risk categories
- ✅ 15+ pre-loaded HGV hazards
- ✅ Complete control measures
- ✅ Default permissions for 3 roles

### Ready to Use
- ✅ Create locations with opening hours
- ✅ Set delivery time windows
- ✅ Create risk assessments
- ✅ Use hazard library templates
- ✅ Track version history
- ✅ View audit logs (admin)
- ✅ Export PDFs
- ✅ Customize themes

---

## 🔧 Troubleshooting

### Database Import Error
```bash
# Check MySQL is running
sudo systemctl status mysql

# Check database doesn't exist
mysql -u root -p -e "DROP DATABASE IF EXISTS risk_assessment_db;"

# Import again
mysql -u root -p < database/complete_schema.sql
```

### Permission Denied
```bash
# Run quick fix
bash QUICK_FIX.sh

# Manual fix
chmod 755 public/uploads/assessments
chmod 755 public/uploads/hazard-library
chmod 755 logs
```

### 500 Error on Dashboard
```bash
# Check database is fully imported
mysql -u root -p risk_assessment_db -e "SHOW TABLES;"

# Should show 23 tables
# If not, re-import schema
```

### No Styling (Plain Page)
```bash
# Run quick fix
bash QUICK_FIX.sh

# Verify assets location
ls -la public/assets/css/style.css

# Should exist and be ~8KB
```

---

## 📚 Next Steps

After successful installation:

1. **Change Admin Password**
   - Login → Click "admin" → Edit Profile
   - Set strong password

2. **Create Your First Location**
   - Locations → + New Location
   - Add opening hours and delivery windows

3. **Create Assessment**
   - Assessments → + New Assessment
   - Use hazard library templates
   - Generate PDF report

4. **Add Users**
   - Users → + New User
   - Assign appropriate role (Admin/Assessor/Viewer)

5. **Customize System**
   - Settings → Themes (choose color scheme)
   - Settings → PDF Templates (customize exports)
   - Settings → Permissions (adjust access)

6. **Enable Production Mode**
   - Edit config/config.php
   - Set `ENVIRONMENT` to 'production'
   - Enable error logging

---

## 🎯 Key Features to Explore

### Location Management
- Opening hours by day
- Delivery time windows
- Contact information
- Parking & access details
- Live "Open Now" status

### Hazard Library
- 15+ pre-loaded templates
- Quick-add to assessments
- Control measure hierarchies
- Reference photos

### Audit & Compliance
- Complete audit trail
- Version control
- User activity tracking
- Compliance reporting

### Assessment Tools
- Risk matrix calculations
- PDF export
- Action item tracking
- Photo attachments

---

## 💡 Tips

### For Best Results
- Create locations before assessments
- Use hazard library templates to save time
- Regular backups of database
- Monitor audit logs weekly
- Update location hours seasonally

### Performance
- System handles 1000+ assessments easily
- Typical page load: < 200ms
- PDF generation: < 2 seconds
- Works great on mobile

### Support
- Check DEPLOYMENT_AND_TESTING_GUIDE.md for details
- Run SYSTEM_CHECKER.php to diagnose issues
- Review logs/php_errors.log for errors
- Consult specific guides for features

---

## 📋 Installation Checklist

Pre-Installation:
- [ ] Web server installed (Apache/Nginx)
- [ ] PHP 8.0+ installed
- [ ] MySQL 8.0+ installed
- [ ] Required PHP extensions enabled

Installation:
- [ ] Files extracted
- [ ] Database created (complete_schema.sql)
- [ ] config.php configured
- [ ] Permissions set (QUICK_FIX.sh)
- [ ] System checker shows 100% pass

Post-Installation:
- [ ] Can login with admin/admin123
- [ ] Dashboard loads without errors
- [ ] Can create location
- [ ] Can create assessment
- [ ] Admin password changed
- [ ] SSL/HTTPS enabled (production)

---

**Total Installation Time: ~5 minutes**

**Difficulty: Easy** - Single SQL file, automated setup

**Result: Production-ready system** with all features enabled!

For detailed information, see:
- DEPLOYMENT_AND_TESTING_GUIDE.md
- RELEASE_NOTES_V3.4.txt
- README.md
