#!/bin/bash

echo "=========================================="
echo "Quick Fix Script - v3.3.0"
echo "=========================================="
echo ""

# Fix 1: Set proper permissions
echo "1. Setting file permissions..."
find . -type d -exec chmod 755 {} \;
find . -type f -exec chmod 644 {} \;
chmod 755 public/uploads/assessments
chmod 755 public/uploads/hazard-library
chmod 755 logs
echo "✓ Permissions set"

# Fix 2: Create missing directories
echo ""
echo "2. Creating missing directories..."
mkdir -p public/uploads/assessments
mkdir -p public/uploads/hazard-library
mkdir -p logs
echo "✓ Directories created"

# Fix 3: Check database connection
echo ""
echo "3. Testing database connection..."
php -r "
require_once 'config/config.php';
require_once 'includes/Database.php';
try {
    \$db = Database::getInstance();
    echo '✓ Database connection successful\n';
} catch (Exception \$e) {
    echo '✗ Database error: ' . \$e->getMessage() . '\n';
    echo 'Check config/config.php settings\n';
}
"

# Fix 4: Verify assets location
echo ""
echo "4. Checking assets location..."
if [ -d "public/assets" ]; then
    echo "✓ Assets in correct location"
else
    if [ -d "assets" ]; then
        echo "Moving assets to public/assets..."
        mv assets public/assets
        echo "✓ Assets moved"
    else
        echo "✗ Assets not found!"
    fi
fi

# Fix 5: Test critical files
echo ""
echo "5. Testing critical files..."
for file in "public/dashboard.php" "public/login.php" "public/index.php"; do
    if [ -f "$file" ]; then
        php -l "$file" > /dev/null 2>&1
        if [ $? -eq 0 ]; then
            echo "✓ $file - syntax OK"
        else
            echo "✗ $file - syntax error"
        fi
    else
        echo "✗ $file - not found"
    fi
done

echo ""
echo "=========================================="
echo "Quick Fix Complete!"
echo "=========================================="
echo ""
echo "Next steps:"
echo "1. Visit http://yourdomain.com/SYSTEM_CHECKER.php"
echo "2. Review any remaining issues"
echo "3. Test login at http://yourdomain.com/public/login.php"
echo ""
