# New Features Guide - v3.1.0

## 🎨 Color Scheme Customization

### Overview
Administrators can now create, manage, and apply custom color schemes system-wide. Users can select their preferred theme for a personalized experience.

### Features
- **6 Built-in Themes**: Modern Indigo, Ocean Blue, Forest Green, Sunset Orange, Royal Purple, Corporate Gray
- **Custom Theme Creation**: Define your own color palette
- **Live Preview**: See changes before applying
- **User Preferences**: Each user can choose their theme
- **System Default**: Set a default theme for all new users

### How to Use

**Access**: Settings → Color Themes (Admin Only)

**Create New Theme**:
1. Click "Create Theme"
2. Enter theme name
3. Select colors:
   - Primary (main brand color)
   - Secondary (complementary color)
   - Accent (highlights)
   - Success/Warning/Danger (status colors)
   - Background gradient (start & end)
4. Preview in real-time
5. Click "Save Theme"

**Apply Theme**:
- Click "Apply" on any theme card
- Theme applies instantly
- Saved to your user preferences

**Set Default**:
- Click "Set Default" on any theme
- Becomes the default for all new users

### Technical Details

**Database Tables**:
- `color_themes`: Stores theme definitions
- `user_preferences`: Links users to their preferred themes

**CSS Variables**: Themes update CSS custom properties dynamically
```css
--primary: #6366f1
--secondary: #8b5cf6
--success: #10b981
```

---

## 🔐 Permissions Management

### Overview
Granular control over user permissions with role-based access control (RBAC). Define exactly what each role can do with each resource.

### Features
- **CRUD Permissions**: Create, Read, Update, Delete
- **Role-Based**: Admin, Assessor, Viewer
- **Resource-Level**: Control access per resource type
- **Custom Resources**: Add new resources dynamically
- **Visual Interface**: Checkbox grid for easy management

### How to Use

**Access**: Settings → Permissions (Admin Only)

**Update Permissions**:
1. Find the resource (e.g., assessments, locations)
2. Toggle checkboxes for each role:
   - ✓ Create: Can add new records
   - ✓ Read: Can view records
   - ✓ Update: Can edit records
   - ✓ Delete: Can remove records
3. Click "Save All Permissions"

**Add New Resource**:
1. Click "Add Resource"
2. Enter resource name (lowercase, singular)
3. Default permissions auto-created:
   - Admin: Full access
   - Assessor: Read only
   - Viewer: Read only
4. Customize as needed

### Default Permissions

| Resource | Admin | Assessor | Viewer |
|----------|-------|----------|--------|
| Assessments | CRUD | CRU | R |
| Locations | CRUD | CRU | R |
| Users | CRUD | - | - |

### Technical Details

**Database Table**: `permissions`
```sql
- role: ENUM('admin', 'assessor', 'viewer')
- resource: VARCHAR(50)
- can_create, can_read, can_update, can_delete: TINYINT(1)
```

**Check Permission in Code**:
```php
if ($auth->hasPermission('assessments', 'update')) {
    // User can update assessments
}
```

---

## 📄 Customizable PDF Export

### Overview
Create multiple PDF templates with different layouts, styling, and content options. Choose which template to use when exporting assessments.

### Features
- **Multiple Templates**: Create unlimited export layouts
- **Customizable Content**: Choose which fields to include
- **Branding**: Add logo and custom headers/footers
- **Layout Options**: Portrait/landscape, font selection
- **Conditional Sections**: Toggle photos, actions, signatures
- **Custom CSS**: Advanced styling control

### How to Use

**Access**: Settings → PDF Templates (Admin Only)

**Create Template**:
1. Click "Create Template"
2. Configure:
   - **Name**: Template identifier
   - **Orientation**: Portrait or Landscape
   - **Font**: Arial, Helvetica, Times New Roman, Courier
   - **Font Size**: 8-16pt
   - **Header Logo**: URL to your logo
   - **Header/Footer Text**: Custom text (use {{date}} for dynamic date)
3. Select included fields:
   - Title, Location, Visit Date, Assessor
   - Vehicle Type, Weather, Description
4. Toggle sections:
   - ☑ Risk Matrix
   - ☑ Photos
   - ☑ Action Items
   - ☐ Signature Section
5. Add custom CSS (optional)
6. Click "Save Template"

**Export with Template**:
1. Open any assessment
2. Select template from dropdown
3. Click "Export PDF"
4. PDF opens in new tab
5. Print or save as needed

**Set Default Template**:
- Click "Set Default" on any template
- Used when no template specified

### Template Examples

**Detailed Report**:
- All fields included
- Shows photos and action items
- Signature section enabled
- Portrait, 12pt Arial

**Executive Summary**:
- Key fields only (title, location, date)
- No photos
- Risk matrix only
- Landscape, 10pt Helvetica

**Field Report**:
- All operational fields
- Photos included
- No signatures
- Portrait, 11pt Arial

### Technical Details

**Database Table**: `pdf_templates`
```sql
- template_name, page_orientation, font_family, font_size
- header_logo_url, header_text, footer_text
- show_risk_matrix, show_photos, show_action_items, show_signatures
- include_fields (JSON), custom_css (TEXT)
```

**Generate PDF**:
```php
$pdfManager = new PDFTemplateManager();
$html = $pdfManager->generatePDFHTML($assessment, $risks, $actions, $templateId);
```

---

## 🔄 Integration Guide

### Applying Changes

**Initial Setup**:
1. Import database additions:
   ```bash
   mysql -u root -p risk_assessment_db < database/schema_additions.sql
   ```

2. Access the system
3. Go to Settings (Admin)
4. Configure new features:
   - Create/apply themes
   - Review permissions
   - Set up PDF templates

**User Experience**:
1. Users see theme selector in profile (future)
2. Permissions enforced on all pages
3. PDF export shows template dropdown

### API Endpoints

**Set User Theme**:
```javascript
POST /api/set-user-theme.php
Body: { "theme_id": 1 }
Response: { "success": true }
```

### Navigation

New admin menu items:
- Settings → 🎨 Color Themes
- Settings → 🔐 Permissions
- Settings → 📄 PDF Templates

---

## 🎯 Best Practices

### Themes
- Create 2-3 themes for different preferences
- Test readability on all pages
- Ensure sufficient contrast
- Avoid very bright backgrounds

### Permissions
- Follow principle of least privilege
- Test with each role after changes
- Document custom resources
- Review quarterly

### PDF Templates
- Create role-specific templates
- Test printing before rollout
- Include branding elements
- Keep file sizes reasonable

---

## 🐛 Troubleshooting

### Theme Not Applying
- Clear browser cache
- Check user_preferences table
- Verify theme is active
- Check CSS variable support

### Permission Denied
- Verify role in users table
- Check permissions table
- Look for typos in resource names
- Review audit_log for changes

### PDF Not Generating
- Check template exists and is active
- Verify assessment data complete
- Review custom CSS for errors
- Check browser console

---

## 📊 Database Changes

**New Tables**:
- `color_themes` (9 columns)
- `pdf_templates` (14 columns)
- `user_preferences` (4 columns)

**Modified Tables**:
- None (fully backward compatible)

**Sample Data**:
- 6 color themes
- 1 default PDF template

---

## ✅ Feature Checklist

Color Themes:
- [x] Create themes
- [x] Edit themes
- [x] Delete themes
- [x] Set default
- [x] User preferences
- [x] Live preview
- [x] CSS generation

Permissions:
- [x] View all permissions
- [x] Update permissions
- [x] Add resources
- [x] Role-based checking
- [x] Audit logging

PDF Templates:
- [x] Create templates
- [x] Edit templates
- [x] Delete templates
- [x] Set default
- [x] Template selection
- [x] Custom layouts
- [x] HTML generation

---

**Version**: 3.1.0
**Status**: Production Ready
**Last Updated**: February 2026
