#!/bin/bash

echo "=========================================="
echo "Photo Upload Installation Script v3.4.2"
echo "=========================================="
echo ""

ERRORS=0

# Step 1: Add photos column to database
echo "Step 1: Adding photos column to database..."
mysql -u root -p risk_assessment_db << 'EOFMYSQL'
ALTER TABLE assessment_risks 
ADD COLUMN IF NOT EXISTS photos JSON NULL COMMENT 'Array of photo filenames attached to this risk item';

SELECT 'Photos column added successfully!' as Status;
EOFMYSQL

if [ $? -eq 0 ]; then
    echo "   ✓ Photos column added to assessment_risks table"
else
    echo "   ✗ Failed to add photos column"
    ERRORS=$((ERRORS+1))
fi

# Step 2: Create upload directory
echo ""
echo "Step 2: Creating upload directory..."
mkdir -p public/uploads/assessments
chmod 755 public/uploads/assessments

if [ -d "public/uploads/assessments" ]; then
    echo "   ✓ Upload directory created: public/uploads/assessments/"
else
    echo "   ✗ Failed to create upload directory"
    ERRORS=$((ERRORS+1))
fi

# Step 3: Set proper permissions
echo ""
echo "Step 3: Setting permissions..."
chmod 755 public/uploads/assessments
chown -R www-data:www-data public/uploads/assessments 2>/dev/null || chown -R nginx:nginx public/uploads/assessments 2>/dev/null

echo "   ✓ Permissions set"

# Step 4: Verify files exist
echo ""
echo "Step 4: Verifying required files..."

FILES=(
    "includes/PhotoUpload.php"
    "includes/partials/photo-upload.php"
    "public/api/upload-photo.php"
    "public/api/delete-photo.php"
    "public/assets/js/main.js"
)

for file in "${FILES[@]}"; do
    if [ -f "$file" ]; then
        echo "   ✓ $file exists"
    else
        echo "   ✗ $file MISSING"
        ERRORS=$((ERRORS+1))
    fi
done

# Step 5: Test PHP GD library
echo ""
echo "Step 5: Checking PHP GD library..."
php -m | grep -q -i gd
if [ $? -eq 0 ]; then
    echo "   ✓ PHP GD library is installed"
else
    echo "   ✗ PHP GD library NOT installed"
    echo "   Install with: sudo apt-get install php-gd"
    echo "   Then restart: sudo systemctl restart apache2"
    ERRORS=$((ERRORS+1))
fi

# Summary
echo ""
echo "=========================================="
if [ $ERRORS -eq 0 ]; then
    echo "✅ INSTALLATION COMPLETE!"
    echo ""
    echo "Photo upload functionality is ready to use."
    echo ""
    echo "Next steps:"
    echo "1. Login to the system"
    echo "2. Open any assessment"
    echo "3. Each risk item now has a photo upload section"
    echo "4. Click 'Add Photo' to upload images"
    echo ""
else
    echo "❌ INSTALLATION FAILED"
    echo ""
    echo "Found $ERRORS error(s). Please fix them and run again."
    echo ""
fi
echo "=========================================="
