# Installation Checklist

## ✅ Pre-Installation Checks

- [ ] PHP 8.0+ installed
- [ ] MySQL 8.0+ installed  
- [ ] Apache or Nginx configured
- [ ] mod_rewrite enabled (Apache)
- [ ] GD library installed (for image processing)

## 📦 Installation Steps

### 1. Extract Files
```bash
cd /var/www/html
tar -xzf risk-assessment-v3.2-complete.tar.gz
cd risk-assessment-modern-v3
```

### 2. Verify Directory Structure
```bash
ls -la public/assets/css/style.css
ls -la public/assets/js/main.js
```

Expected output:
- ✓ public/assets/css/style.css exists
- ✓ public/assets/js/main.js exists

### 3. Database Setup
```bash
mysql -u root -p

# In MySQL console:
CREATE DATABASE risk_assessment_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE risk_assessment_db;
SOURCE database/schema.sql;
SOURCE database/schema_additions.sql;
SOURCE database/hazard_library_schema.sql;
EXIT;
```

### 4. Configure Application
```bash
nano config/config.php
```

Update these settings:
```php
define('DB_HOST', 'localhost');          // Your DB host
define('DB_NAME', 'risk_assessment_db'); // Your DB name
define('DB_USER', 'your_username');      // Your DB user
define('DB_PASS', 'your_password');      // Your DB password
```

The BASE_URL and SITE_URL are auto-detected, but verify:
```php
// Should auto-detect correctly:
// BASE_URL: http://yourdomain.com/risk-assessment-modern-v3
// SITE_URL: http://yourdomain.com/risk-assessment-modern-v3/public/
```

### 5. Set Permissions
```bash
# Make directories writable
chmod 755 public/uploads/assessments
chmod 755 public/uploads/hazard-library  
chmod 755 logs/

# Set ownership (Apache)
chown -R www-data:www-data .

# Or for Nginx
chown -R nginx:nginx .

# Protect config
chmod 644 config/config.php
```

### 6. Configure Web Server

**Apache** (.htaccess already included):
```bash
# Enable mod_rewrite
sudo a2enmod rewrite
sudo systemctl restart apache2
```

**Nginx** (add to server block):
```nginx
root /var/www/html/risk-assessment-modern-v3/public;
index index.php;

location / {
    try_files $uri $uri/ /index.php?$query_string;
}

location ~ \.php$ {
    include fastcgi_params;
    fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
    fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
}

location /assets/ {
    expires 30d;
    add_header Cache-Control "public, immutable";
}
```

### 7. Test CSS Loading
```bash
# Visit test page
http://yourdomain.com/public/test-css.php
```

Expected results:
- ✓ Page has gradient background (purple/indigo)
- ✓ Card has rounded corners and shadow
- ✓ Buttons are styled with colors
- ✓ Badges show different colors
- ✓ Browser console shows "JavaScript loaded successfully!"

### 8. Access Application
```
http://yourdomain.com/public/
```

**Default Login:**
- Username: `admin`
- Password: `admin123`

⚠️ **IMPORTANT**: Change password immediately after first login!

## 🔍 Troubleshooting CSS Issues

### CSS Not Loading?

**Check 1: File Exists**
```bash
ls -la public/assets/css/style.css
```
Should show ~8KB file.

**Check 2: Permissions**
```bash
chmod 644 public/assets/css/style.css
chmod 755 public/assets/css/
chmod 755 public/assets/
```

**Check 3: Web Server Access**
```bash
# Test direct access
curl http://localhost/public/assets/css/style.css
```
Should return CSS content.

**Check 4: Browser Developer Tools**
- Press F12
- Go to Network tab
- Reload page
- Look for style.css
- Check status (should be 200, not 404)
- Click on it to see content

**Check 5: PHP Config Variables**
Add to top of test-css.php:
```php
<?php
require_once '../config/config.php';
echo "BASE_URL: " . BASE_URL . "<br>";
echo "SITE_URL: " . SITE_URL . "<br>";
echo "CSS Path: " . SITE_URL . "assets/css/style.css<br>";
?>
```

### Common Issues

**404 on CSS file**
- ✓ Verify assets folder is inside public/
- ✓ Check .htaccess allows static files
- ✓ Verify mod_rewrite is enabled

**Blank page**
- ✓ Check PHP error log
- ✓ Enable display_errors in config.php temporarily
- ✓ Check file permissions

**No styling but file loads**
- ✓ Check browser console for CSS errors
- ✓ Verify CSS file is not empty
- ✓ Check Content-Type header (should be text/css)

## ✅ Post-Installation Checks

### Verify All Features Work

- [ ] Login page loads with styling
- [ ] Dashboard displays with cards and stats
- [ ] Assessments page loads
- [ ] Can create new assessment
- [ ] Hazard library displays
- [ ] Can upload photos
- [ ] Theme selector works (Settings → Themes)
- [ ] PDF export works
- [ ] Permissions page loads (Admin)

### Performance Checks

- [ ] CSS loads in <200ms
- [ ] JS loads in <200ms  
- [ ] Pages render in <1s
- [ ] No console errors
- [ ] Mobile view works

### Security Checks

- [ ] Change default admin password
- [ ] Verify uploads directory protected
- [ ] Check .htaccess security headers
- [ ] Test permission system
- [ ] Review audit log

## 🎉 Success Indicators

When everything is working:
- ✅ Login page has purple gradient background
- ✅ Cards have glassmorphism effect
- ✅ Buttons have gradient colors with hover effects
- ✅ Tables have modern styling
- ✅ Navigation bar is sticky with blur effect
- ✅ Forms have modern inputs with focus states
- ✅ Badges are colored and rounded
- ✅ Stat cards have gradient top border
- ✅ No console errors
- ✅ All pages load quickly

## 📞 Getting Help

If CSS still won't load after following all steps:

1. **Check server error logs:**
   ```bash
   tail -f /var/log/apache2/error.log
   # or
   tail -f /var/log/nginx/error.log
   ```

2. **Enable PHP error display temporarily:**
   ```php
   // In config/config.php
   error_reporting(E_ALL);
   ini_set('display_errors', 1);
   ```

3. **Verify file paths in browser:**
   - Right-click page → View Page Source
   - Look for: `<link rel="stylesheet" href="...style.css">`
   - Copy that URL
   - Paste in browser address bar
   - Should load CSS file content

4. **Check Apache/Nginx configuration:**
   - Verify DocumentRoot points to correct directory
   - Check AllowOverride All is set (Apache)
   - Verify PHP-FPM is running

## 🔧 Quick Fixes

**Quick Fix #1: Direct Path**
If SITE_URL detection fails, hardcode in header.php:
```php
<link rel="stylesheet" href="/public/assets/css/style.css">
```

**Quick Fix #2: Absolute Path**  
Use absolute path in header.php:
```php
<link rel="stylesheet" href="https://yourdomain.com/public/assets/css/style.css">
```

**Quick Fix #3: Inline Backup**
Add critical CSS inline in header.php as fallback:
```php
<style>
    @import url('assets/css/style.css');
</style>
```

---

**Last Updated:** February 2026
**Version:** 3.2.0
