# Hazard Library System Guide

## 🎯 Overview

The Hazard Library is a powerful feature that allows you to create, manage, and reuse predefined hazard templates with associated control measures and reference photographs. This dramatically speeds up risk assessment creation and ensures consistency across assessments.

---

## ✨ Key Features

### Hazard Templates
- **Predefined Hazards**: Create reusable hazard templates
- **Rich Descriptions**: Detailed hazard information
- **Risk Ratings**: Default likelihood and severity scores
- **Category Organization**: Group by risk category
- **Usage Tracking**: See which hazards are most used
- **Affected Persons**: Track who is at risk

### Control Measures
- **Hierarchy of Controls**: Following industry best practices
  - 🚫 Elimination
  - 🔄 Substitution
  - ⚙️ Engineering Controls
  - 📋 Administrative Controls
  - 🦺 PPE
- **Effectiveness Ratings**: High, Medium, Low
- **Implementation Notes**: Guidance on applying controls
- **Multiple Controls per Hazard**: Comprehensive risk management

### Reference Photography
- **Upload Multiple Photos**: Document hazards visually
- **Primary Photo**: Featured image for the hazard
- **Thumbnails**: Quick preview in listings
- **Photo Captions**: Describe what's shown
- **Photo Management**: Add, view, delete photos
- **Library Storage**: Separate from assessment-specific photos

### Quick Integration
- **Add to Assessments**: One-click addition from library
- **Search & Filter**: Find hazards quickly
- **Category Filtering**: Browse by risk type
- **Visual Selection**: Photo-based selection interface

---

## 📚 Using the Hazard Library

### Accessing the Library

**Navigation**: Main Menu → Hazard Library

**View Options**:
- Grid view with photos
- Search by keyword
- Filter by category
- Sort by usage

### Creating a Hazard Template

1. **Go to Hazard Library**
2. Click "**+ Create Hazard Template**"

3. **Fill in Basic Information**:
   - **Name**: Clear, descriptive (e.g., "Reversing Collisions")
   - **Category**: Select appropriate risk category
   - **Description**: Detailed explanation of the hazard
   - **Who is Affected**: List affected persons
   - **Residual Risk Level**: After controls applied

4. **Set Risk Assessment Defaults**:
   - **Likelihood** (1-5): How often it might occur
   - **Severity** (1-5): Potential impact
   - **Risk Score**: Auto-calculated
   - **Risk Level**: Auto-determined

5. **Add Control Measures**:
   - **Quick Controls**: Simple list (one per line)
   - **Detailed Controls** (optional):
     - Control type (elimination, substitution, etc.)
     - Description
     - Implementation notes
     - Effectiveness rating

6. **Click "Create Hazard Template"**

### Adding Reference Photos

**From Hazard View Page**:

1. Open the hazard
2. Click "**📸 Upload Photo**"
3. Select image (JPG, PNG, GIF, WebP)
4. Photo appears immediately
5. First photo becomes primary automatically

**Photo Features**:
- Max 5MB per photo
- Automatic resizing to 1600px
- Thumbnail generation (300x300px)
- Click to view full size
- Delete button on hover

### Using Hazards in Assessments

**Method 1: From Assessment (Recommended)**

1. Open any assessment (edit mode)
2. Click "**📚 Add from Hazard Library**"
3. Search or browse hazards
4. Click on hazard card to add
5. Hazard automatically added to assessment
6. Edit as needed for specific situation

**Method 2: Direct Link**

1. From hazard view page
2. Click "**➕ Add to Assessment**"
3. Copy the quick-add link
4. Use in assessment context

**What Gets Copied**:
- Hazard name and description
- Default likelihood and severity
- Typical control measures
- Link to original template

**What You Can Customize**:
- Adjust likelihood/severity for this location
- Modify control measures
- Add location-specific photos
- Add additional notes

---

## 🎨 Best Practices

### Creating Effective Templates

**Hazard Names**:
- Be specific and descriptive
- Use action-oriented language
- Example: "Reversing Collisions" not just "Reversing"

**Descriptions**:
- Explain when/where hazard occurs
- Describe the risk mechanism
- Include typical scenarios
- Mention key factors

**Control Measures**:
- Follow hierarchy of controls
- Be specific and actionable
- Include implementation details
- Note costs if significant

**Photography**:
- Take clear, focused images
- Show the hazard clearly
- Include context
- Multiple angles helpful
- Good lighting essential

### Organizing Your Library

**Use Categories Wisely**:
- Vehicle Operations
- Loading/Unloading
- Access & Egress
- Environmental
- People & Pedestrians

**Regular Maintenance**:
- Review unused hazards quarterly
- Update based on incidents
- Add photos as available
- Refine control measures
- Archive obsolete hazards

**Training**:
- Train assessors on library use
- Create onboarding guide
- Share best hazard examples
- Encourage photo submissions

---

## 🔍 Search & Discovery

### Search Features

**Keyword Search**:
- Searches name and description
- Real-time filtering
- Case-insensitive
- Partial matching

**Category Filter**:
- Filter by risk category
- Combine with search
- Quick navigation

**Visual Browse**:
- Photo-based cards
- Risk level badges
- Usage statistics
- Control counts

### Finding the Right Hazard

**By Activity**:
- Think about the task
- What could go wrong?
- Search for activity name

**By Location**:
- Consider area hazards
- Search by location type
- Filter by category

**By Incident Type**:
- Review past incidents
- Search for similar
- Check recommendations

---

## 📊 Pre-Loaded Hazards

The system comes with 15+ pre-configured hazards including:

**Vehicle Operations**:
- Reversing Collisions
- Vehicle Rollover
- Blind Spot Incidents

**Loading/Unloading**:
- Manual Handling Injuries
- Falls from Height
- Crushing Injuries
- Falling Objects

**Access & Egress**:
- Slips and Trips
- Unsafe Access Points
- Door Strike Injuries

**Environmental**:
- Poor Visibility
- Ice and Snow Hazards
- Extreme Weather

**People & Pedestrians**:
- Vehicle-Pedestrian Collision
- Contractor Coordination
- Lone Working

Each includes:
- ✅ Detailed description
- ✅ Default risk ratings
- ✅ Control measures
- ✅ Affected persons

---

## 🔐 Permissions

### Required Permissions

**View Library**: All users can view

**Create Templates**: 
- Requires: "Create" permission on assessments
- Role: Assessor, Admin

**Edit Templates**:
- Requires: "Update" permission on assessments
- Role: Assessor, Admin

**Delete Templates**:
- Requires: "Delete" permission on assessments
- Role: Admin only

**Upload Photos**:
- Requires: "Update" permission on assessments
- Role: Assessor, Admin

---

## 💡 Advanced Features

### Control Measure Types

**Elimination** (Most Effective):
- Remove the hazard entirely
- Example: Automate manual tasks
- Cost: Often high upfront
- Effectiveness: Highest

**Substitution**:
- Replace with something safer
- Example: Electric forklifts vs diesel
- Cost: Moderate
- Effectiveness: High

**Engineering Controls**:
- Physical changes
- Example: Guards, barriers, ventilation
- Cost: Moderate to high
- Effectiveness: High

**Administrative Controls**:
- Procedures and training
- Example: Safe work procedures, signage
- Cost: Low to moderate
- Effectiveness: Medium

**PPE** (Least Effective):
- Personal protective equipment
- Example: Hard hats, safety boots
- Cost: Low
- Effectiveness: Low to medium

### Usage Statistics

**Track Performance**:
- Times used in assessments
- Most/least popular hazards
- Last used date
- Effectiveness over time

**Continuous Improvement**:
- Review underused hazards
- Update based on feedback
- Retire obsolete templates
- Create new as needed

---

## 🛠️ Technical Details

### Database Tables

**risk_items** (Enhanced):
- Template flag
- Photos (JSON array)
- Typical controls
- Affected persons
- Residual risk level
- Usage tracking

**control_measures**:
- Control type
- Description
- Implementation notes
- Effectiveness rating
- Display order

**hazard_library_photos**:
- Filename
- Caption
- Primary flag
- Display order
- Upload tracking

**assessment_risks** (Enhanced):
- Template ID reference
- Tracks original template used
- Allows independent editing

### File Storage

**Location**: `/uploads/hazard-library/`

**File Naming**: 
```
hazard_{id}_{timestamp}_{hash}.{ext}
thumb_hazard_{id}_{timestamp}_{hash}.{ext}
```

**Supported Formats**:
- JPEG (.jpg, .jpeg)
- PNG (.png)
- GIF (.gif)
- WebP (.webp)

**Size Limits**:
- Max file size: 5MB
- Max dimensions: 1600x1600px
- Thumbnail: 300x300px (square crop)

### API Endpoints

**Search Hazards**:
```
GET /api/search-hazards.php?search=term&category=id
```

**Add to Assessment**:
```
POST /api/add-hazard-to-assessment.php
Body: { hazard_id, assessment_id }
```

**Upload Photo**:
```
POST /api/upload-hazard-photo.php
FormData: { photo, hazard_id, caption }
```

**Delete Photo**:
```
POST /api/delete-hazard-photo.php
Body: { photo_id }
```

---

## 📋 Workflow Examples

### Example 1: New Site Setup

**Scenario**: Setting up assessments for a new delivery location

1. Review site layout
2. Identify common hazards
3. Search library for relevant hazards:
   - "reversing" → Reversing Collisions
   - "pedestrian" → Vehicle-Pedestrian Collision
   - "loading" → Falls from Height
4. Add all applicable hazards to assessment
5. Customize for specific site features
6. Take site-specific photos
7. Adjust control measures as needed

**Time Saved**: 60-70% compared to creating from scratch

### Example 2: Incident Response

**Scenario**: Near-miss with forklift and pedestrian

1. Document incident
2. Review existing hazard: Vehicle-Pedestrian Collision
3. Add actual incident photos
4. Update control measures based on findings
5. Enhanced template now available for all sites
6. Roll out improved controls company-wide

**Benefit**: Continuous improvement across organization

### Example 3: Seasonal Updates

**Scenario**: Winter weather approaching

1. Search for "ice" or "winter"
2. Find: Ice and Snow Hazards
3. Add to all outdoor site assessments
4. Update with current weather forecasts
5. Add site-specific controls
6. Review after winter season
7. Update template for next year

**Benefit**: Proactive risk management

---

## 🎯 Success Metrics

### Track Your Success

**Efficiency Gains**:
- Assessment creation time
- Consistency across assessments
- Template reuse rate
- Photo library size

**Quality Improvements**:
- Control measure completeness
- Assessment thoroughness
- Incident reduction
- Audit performance

**User Adoption**:
- Library usage rate
- New templates created
- Photos uploaded
- User feedback

---

## 🆘 Troubleshooting

### Common Issues

**Photos Won't Upload**:
- Check file size (<5MB)
- Verify file format (JPEG, PNG, GIF, WebP)
- Check upload permissions
- Clear browser cache

**Hazard Not Appearing in Assessment**:
- Verify assessment not locked
- Check user permissions
- Refresh page
- Check browser console for errors

**Controls Not Saving**:
- Fill all required fields
- Check for special characters
- Verify character limits
- Try shorter text

**Search Not Working**:
- Clear search filters
- Try different keywords
- Check category filter
- Reload page

---

## 🎓 Training Guide

### For Administrators

1. **Setup**:
   - Import database schema
   - Create initial templates
   - Upload reference photos
   - Set permissions

2. **Customization**:
   - Add company-specific hazards
   - Define standard controls
   - Create photo library
   - Train assessors

3. **Maintenance**:
   - Review usage statistics
   - Update templates quarterly
   - Archive unused items
   - Gather feedback

### For Assessors

1. **Getting Started**:
   - Tour the hazard library
   - Understand categories
   - Learn search features
   - Practice adding hazards

2. **Creating Assessments**:
   - Start with library search
   - Select relevant hazards
   - Customize for location
   - Add specific photos
   - Document controls

3. **Contributing**:
   - Create new templates
   - Upload quality photos
   - Suggest improvements
   - Share best practices

---

## ✅ Checklist

### Initial Setup
- [ ] Database schema imported
- [ ] Upload directory configured
- [ ] Permissions set correctly
- [ ] Pre-loaded hazards imported
- [ ] Sample photos uploaded
- [ ] Users trained

### Creating Quality Templates
- [ ] Clear, descriptive name
- [ ] Detailed description
- [ ] Accurate risk ratings
- [ ] Comprehensive controls
- [ ] Reference photos added
- [ ] Affected persons listed
- [ ] Category assigned

### Using in Assessments
- [ ] Search library first
- [ ] Select relevant hazards
- [ ] Customize for site
- [ ] Add location photos
- [ ] Review control measures
- [ ] Update risk ratings
- [ ] Complete assessment

---

**Feature Status**: ✅ Production Ready  
**Version**: 3.2.0  
**Last Updated**: February 2026

**Questions?** Check the main documentation or contact your system administrator.
