# Emergency Fix for 500 Errors

## The Problem
Dashboard.php and other pages show 500 errors because theme tables are missing from the database.

## The Solution (2 Minutes)

### Option 1: Reimport Complete Schema (Recommended)

```bash
# This will recreate everything fresh
mysql -u root -p < database/complete_schema.sql
```

⚠️ **Warning:** This drops and recreates the entire database!

If you have existing data, backup first:
```bash
mysqldump -u root -p risk_assessment_db > backup_before_fix.sql
```

### Option 2: Add Missing Tables Only

```bash
# Only adds the 3 missing tables
mysql -u root -p risk_assessment_db < database/theme_tables_addition.sql
```

This is safer if you have existing data.

### Option 3: Use Minimal Dashboard (Temporary)

If you need access immediately:
```
http://yourdomain.com/public/dashboard-minimal.php
```

This works without themes but has basic functionality.

---

## Verification

After applying the fix, verify tables exist:

```bash
mysql -u root -p risk_assessment_db -e "SHOW TABLES;"
```

Should show **26 tables** including:
- color_themes
- user_preferences  
- pdf_templates

---

## Why Did This Happen?

The theme system requires 3 additional tables that weren't in the initial complete_schema.sql.
The updated complete_schema.sql (v3.4.1) now includes these tables.

---

## Test Pages Available

1. **show-errors.php** - Full diagnostic
   - http://yourdomain.com/public/show-errors.php

2. **dashboard-minimal.php** - Working dashboard without themes
   - http://yourdomain.com/public/dashboard-minimal.php

3. **diagnose.php** - Quick system check
   - http://yourdomain.com/public/diagnose.php

---

## After Fix

Once fixed, you should be able to access:
- ✅ Dashboard
- ✅ Assessments
- ✅ Locations
- ✅ All other pages

---

**Fix Time:** ~2 minutes
**Difficulty:** Easy
**Data Loss:** None (if using Option 2)
