# Risk Assessment System v3.4.0 - Deployment & Testing Guide

## 🎉 What's New in v3.4.0

### Enhanced Location Management
- ✅ **Opening Hours by Day** - Set different hours for each day
- ✅ **Delivery Time Windows** - Multiple delivery slots per day
- ✅ **Contact Information** - Site contact details
- ✅ **Parking & Access Info** - Detailed access instructions
- ✅ **Delivery Restrictions** - Vehicle size, weight limits
- ✅ **Special Instructions** - Custom delivery notes
- ✅ **Live Status Indicators** - See if location is open now
- ✅ **Today's Delivery Windows** - Current day schedule display

### System Improvements
- ✅ **Dashboard Error Handling** - Fixed 500 errors
- ✅ **Comprehensive System Checker** - Test all endpoints
- ✅ **Permission Validation** - All pages check permissions
- ✅ **Quick Fix Script** - Automated issue resolution
- ✅ **Enhanced Error Logging** - Better debugging

---

## 📦 Installation Steps

### Step 1: Extract Files
```bash
cd /var/www/html
tar -xzf risk-assessment-v3.4-complete.tar.gz
cd risk-assessment-modern-v3
```

### Step 2: Run Quick Fix
```bash
bash QUICK_FIX.sh
```

This will:
- Set correct file permissions
- Create necessary directories
- Test database connection
- Verify asset locations
- Check file syntax

### Step 3: Import Database Schemas

**Import ALL schemas in order:**
```bash
mysql -u root -p
CREATE DATABASE risk_assessment_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE risk_assessment_db;

SOURCE database/schema.sql;
SOURCE database/schema_additions.sql;
SOURCE database/hazard_library_schema.sql;
SOURCE database/audit_version_schema.sql;
SOURCE database/location_enhancements_schema.sql;
```

**Verify tables created:**
```sql
SHOW TABLES;
```

Should show 21 tables including:
- locations (with new columns: opening_hours, delivery_windows, etc.)
- location_hours
- delivery_slots
- audit_log
- assessment_versions
- user_activity

### Step 4: Configure Application
```bash
nano config/config.php
```

Update:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'risk_assessment_db');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
```

### Step 5: Set Permissions
```bash
chmod 755 public/uploads/assessments
chmod 755 public/uploads/hazard-library
chmod 755 logs
chown -R www-data:www-data .  # For Apache
# OR
chown -R nginx:nginx .         # For Nginx
```

---

## 🧪 Testing Procedure

### Test 1: System Checker
Visit: `http://yourdomain.com/SYSTEM_CHECKER.php`

**Expected Results:**
- ✅ Database connection successful
- ✅ All 21 tables exist
- ✅ All essential files found
- ✅ No syntax errors in pages
- ✅ Permissions correctly configured
- ✅ Directories writable

**If any tests fail:**
1. Review the error message
2. Run `bash QUICK_FIX.sh` again
3. Check file permissions
4. Verify database connection

### Test 2: Login & Dashboard
1. Visit: `http://yourdomain.com/public/login.php`
2. Login: `admin` / `admin123`
3. Should redirect to dashboard
4. Dashboard should display without errors

**If 500 error occurs:**
```bash
# Check error logs
tail -f logs/php_errors.log
tail -f /var/log/apache2/error.log  # Or nginx/error.log
```

### Test 3: Location Management

**Create Location:**
1. Go to Locations → + New Location
2. Fill in name: "Test Store"
3. Set opening hours for Monday-Friday
4. Add delivery windows (Morning: 08:00-12:00, Afternoon: 13:00-17:00)
5. Add contact info
6. Add parking info
7. Click "Create Location"

**Expected:**
- ✅ Location created successfully
- ✅ Redirects to locations list
- ✅ Shows "Open Now" or "Closed" badge
- ✅ Displays today's delivery windows
- ✅ Contact info visible

**View Location:**
1. Click "View Details" on a location
2. Should show:
   - ✅ Full opening hours table
   - ✅ All delivery windows by day
   - ✅ Contact information
   - ✅ Parking & access info
   - ✅ Delivery restrictions
   - ✅ Map link (if coordinates provided)

**Edit Location:**
1. Click "Edit" on a location
2. Change opening hours
3. Add/remove delivery windows
4. Update contact info
5. Save

**Expected:**
- ✅ All fields pre-populated
- ✅ Can add/remove delivery windows
- ✅ Can toggle days closed
- ✅ Updates save successfully

### Test 4: Assessment Creation
1. Go to Assessments → + New Assessment
2. Select the test location
3. Fill in assessment details
4. Create assessment

**Expected:**
- ✅ Location appears in dropdown
- ✅ Assessment created successfully
- ✅ Audit log entry created

### Test 5: Hazard Library
1. Go to Hazard Library
2. Click on a hazard template
3. View details
4. Click "Add to Assessment"

**Expected:**
- ✅ 15+ pre-loaded hazards visible
- ✅ Can view hazard details
- ✅ Can add to assessment
- ✅ Photos display correctly

### Test 6: Audit System
1. Login as admin
2. Go to Settings → Audit Logs
3. View recent activity

**Expected:**
- ✅ Login action logged
- ✅ Location creation logged
- ✅ Assessment creation logged
- ✅ Can filter by user/action/date
- ✅ Can export to CSV

### Test 7: Version Control
1. Open any assessment
2. Click "Version History"
3. Create a manual version
4. Make changes to assessment
5. Compare versions
6. Restore old version

**Expected:**
- ✅ Version created successfully
- ✅ Timeline displays all versions
- ✅ Can compare versions
- ✅ Can restore versions
- ✅ Auto-backup before restore

### Test 8: User Activity
1. Click your name → My Activity
2. View activity dashboard

**Expected:**
- ✅ Shows today's actions
- ✅ Shows weekly summary
- ✅ Shows monthly summary
- ✅ Lists recent activity

### Test 9: Permissions
**As Admin:**
- ✅ Can see all menu items
- ✅ Can access audit logs
- ✅ Can manage users
- ✅ Can modify all locations

**As Assessor:**
- ✅ Can create locations
- ✅ Can create assessments
- ✅ Cannot see audit logs
- ✅ Can view own activity

**As Viewer:**
- ✅ Can view locations (read-only)
- ✅ Can view assessments (read-only)
- ✅ Cannot create/edit
- ✅ Can view own activity

---

## 🐛 Troubleshooting

### Issue: Dashboard 500 Error

**Symptoms:**
- White page
- 500 Internal Server Error
- No content displayed

**Solution:**
```bash
# Check error logs
tail -f logs/php_errors.log

# Common causes:
# 1. Missing tables - run all SQL schemas
# 2. Wrong permissions - run QUICK_FIX.sh
# 3. PHP errors - check syntax with SYSTEM_CHECKER.php
```

### Issue: Locations Not Showing Opening Hours

**Symptoms:**
- Blank opening hours
- No delivery windows
- Missing contact info

**Solution:**
```bash
# Import location enhancements schema
mysql -u root -p risk_assessment_db < database/location_enhancements_schema.sql

# Verify columns added
mysql -u root -p risk_assessment_db
SHOW COLUMNS FROM locations;
# Should see: opening_hours, delivery_windows, contact_name, etc.
```

### Issue: Permission Denied Errors

**Symptoms:**
- "You do not have permission" messages
- Cannot access certain pages
- Features not visible

**Solution:**
```sql
-- Check permissions
SELECT * FROM permissions WHERE role = 'assessor';

-- Grant missing permissions
INSERT INTO permissions (role, resource, can_read, can_create, can_update, can_delete)
VALUES ('assessor', 'locations', 1, 1, 1, 0);
```

### Issue: Assets Not Loading (No CSS)

**Symptoms:**
- Plain white page
- No styling
- Missing images

**Solution:**
```bash
# Run quick fix
bash QUICK_FIX.sh

# Manually move assets if needed
mv assets public/assets

# Verify location
ls -la public/assets/css/style.css
# Should exist and be ~8KB
```

### Issue: Audit Logs Empty

**Symptoms:**
- No audit entries
- Activity not tracked
- Version history empty

**Solution:**
```bash
# Import audit schema
mysql -u root -p risk_assessment_db < database/audit_version_schema.sql

# Verify tables
mysql -u root -p risk_assessment_db -e "SHOW TABLES LIKE '%audit%'"

# Should show: audit_log, assessment_versions, user_activity
```

---

## 📊 Performance Testing

### Load Test: Multiple Users
```bash
# Test with Apache Bench
ab -n 1000 -c 10 http://yourdomain.com/public/dashboard.php

# Expected:
# - Response time < 200ms
# - No failures
# - All requests served
```

### Database Performance
```sql
-- Check slow queries
SHOW FULL PROCESSLIST;

-- Add indexes if needed
CREATE INDEX idx_assessment_location ON assessments(location_id);
CREATE INDEX idx_location_active ON locations(active);
```

### File Upload Test
1. Go to Hazard Library
2. Upload large image (5MB)
3. Should process within 5 seconds
4. Thumbnail generated
5. Image displays correctly

---

## 🔒 Security Checklist

- [ ] Change default admin password
- [ ] Enable HTTPS/SSL
- [ ] Configure firewall rules
- [ ] Set up database backups
- [ ] Review file permissions
- [ ] Enable error logging (disable display_errors)
- [ ] Configure session security
- [ ] Review audit logs weekly
- [ ] Update retention policies
- [ ] Test permission boundaries

---

## 📈 Monitoring

### Daily Checks
- [ ] Check error logs for PHP errors
- [ ] Review failed login attempts
- [ ] Monitor disk space usage
- [ ] Check database size

### Weekly Checks
- [ ] Review audit logs
- [ ] Check user activity
- [ ] Test backup restoration
- [ ] Review version statistics
- [ ] Clean up old logs

### Monthly Checks
- [ ] Full system backup
- [ ] Performance review
- [ ] Security audit
- [ ] User access review
- [ ] Update documentation

---

## ✅ Post-Deployment Checklist

### Configuration
- [ ] Database credentials updated
- [ ] BASE_URL configured correctly
- [ ] Email settings configured
- [ ] Timezone set correctly
- [ ] Error logging enabled

### Data
- [ ] All 5 schemas imported
- [ ] Sample hazards loaded
- [ ] Default admin user exists
- [ ] Permissions configured
- [ ] Retention policies set

### Testing
- [ ] SYSTEM_CHECKER shows 100% pass
- [ ] Dashboard loads without errors
- [ ] Can create locations with hours
- [ ] Can create assessments
- [ ] Audit logging works
- [ ] Version control works
- [ ] All user roles tested

### Security
- [ ] Admin password changed
- [ ] File permissions set (755/644)
- [ ] Upload directories secure
- [ ] HTTPS enabled
- [ ] Error display disabled (production)

### Documentation
- [ ] Users trained on new features
- [ ] Opening hours format documented
- [ ] Delivery window usage explained
- [ ] Support contacts configured
- [ ] Backup procedure documented

---

## 🎯 Success Criteria

System is ready for production when:

1. ✅ SYSTEM_CHECKER shows 100% pass (or only warnings)
2. ✅ Can login and access dashboard
3. ✅ Can create/edit locations with opening hours
4. ✅ Can create/edit assessments
5. ✅ Audit logs recording all actions
6. ✅ Version control creating and restoring versions
7. ✅ All user roles function correctly
8. ✅ No 500 errors on any page
9. ✅ File uploads working
10. ✅ PDFs generating correctly

---

## 📞 Support Resources

### Included Documentation
- README.md - System overview
- AUDIT_VERSION_GUIDE.md - Audit/version features
- HAZARD_LIBRARY_GUIDE.md - Hazard management
- DEPLOYMENT_AND_TESTING_GUIDE.md - This file
- SYSTEM_CHECKER.php - Automated testing
- QUICK_FIX.sh - Issue resolution

### Common Commands
```bash
# View error logs
tail -f logs/php_errors.log

# Check database tables
mysql -u root -p risk_assessment_db -e "SHOW TABLES"

# Test database connection
php -r "require 'config/config.php'; require 'includes/Database.php'; Database::getInstance();"

# Fix permissions
bash QUICK_FIX.sh

# Run system tests
# Visit: http://yourdomain.com/SYSTEM_CHECKER.php
```

---

**Version:** 3.4.0  
**Status:** Production Ready  
**Last Updated:** February 2026  

Complete deployment guide with enhanced location management and comprehensive testing procedures.
