# Changelog

## [3.0.0] - 2026-02-08

### Added
- Complete database schema with 11 tables
- User authentication system with role-based access
- Dashboard with statistics
- Login/logout functionality
- HGV delivery-specific risk categories and items
- UK supermarket location structure with coordinate support
- PWA manifest for offline capability foundation
- Comprehensive documentation

### Core Features
- PHP 8.0+ backend with PDO database layer
- MySQL 8.0+ database with optimized indexes
- Security features (password hashing, prepared statements, XSS protection)
- Session management with timeouts
- Audit logging capability
- Three user roles: Admin, Assessor, Viewer

### Documentation
- README.md - Complete feature overview
- INSTALLATION.md - Step-by-step setup guide
- DEPLOYMENT_NOTES.md - Deployment information
- OFFLINE_AND_PDF_GUIDE.md - PWA and PDF documentation
- PHOTO_ATTACHMENTS_GUIDE.md - Photo upload documentation

### Database
- 11 tables with relationships
- Sample data including admin user and risk categories
- Triggers for automatic risk level calculation
- Views for reporting
- Optimized indexes for performance

### To Be Completed
- Assessment management pages (CRUD)
- Location management pages
- User management pages
- Settings page
- Photo upload functionality
- PDF export
- Google Maps integration
- what3words integration
- Offline sync
- Email notifications
