# Audit and Version Control Guide

## 🎯 Overview

The Risk Assessment System now includes comprehensive auditing and version control capabilities that track all user actions and maintain complete history of assessment changes.

---

## ✨ Features

### Audit Logging
- **Automatic Tracking**: All CRUD operations logged automatically
- **User Actions**: Login, logout, create, update, delete, export
- **Detailed Changes**: Before/after values for all modifications
- **Search & Filter**: Find specific actions by user, date, type
- **Export**: Download audit logs as CSV
- **Retention Policies**: Automatic cleanup of old logs

### Version Control
- **Auto-Save**: Versions created on status changes
- **Manual Save**: Create versions with custom notes
- **Version History**: Complete timeline of all versions
- **Compare Versions**: Side-by-side comparison
- **Restore**: Rollback to any previous version
- **Backup**: Auto-backup before restore

### User Activity
- **Personal Dashboard**: View your own activity
- **Statistics**: Daily, weekly, monthly summaries
- **Action Breakdown**: See what you do most
- **Recent History**: Last 50 actions

---

## 📊 Audit Logs

### Accessing Audit Logs

**Navigation**: Settings → Audit Logs (Admin only)

**What's Logged**:
- ✅ User login/logout
- ✅ Assessment creation/updates/deletion
- ✅ Location management
- ✅ Hazard library changes
- ✅ User management
- ✅ PDF exports
- ✅ Permission changes
- ✅ Theme changes

### Viewing Audit Logs

**Filters Available**:
- User (who performed the action)
- Action type (create, update, delete, etc.)
- Entity type (assessment, location, user, etc.)
- Date range (from/to)
- Search text (entity names, changes)

**Information Displayed**:
- Date and time (precise to the second)
- User who performed action
- Action type (color-coded badge)
- Entity affected
- Summary of changes
- IP address
- Session ID

### Exporting Audit Logs

1. Apply desired filters
2. Click "Export CSV" button
3. CSV file downloads automatically
4. Contains: Date, User, Action, Entity, Changes, IP

**Use Cases**:
- Compliance reporting
- Security audits
- Troubleshooting changes
- Performance analysis
- User activity tracking

---

## 📜 Version Control

### How It Works

**Automatic Versions**:
- Created when assessment status changes
- Created when key fields modified
- Created before restoring old version
- Notes generated automatically

**Manual Versions**:
- Created on-demand by users
- Custom notes can be added
- Useful for milestones/checkpoints
- Before major edits

### Creating Versions

**From Assessment View**:
1. Open any assessment
2. Look for "Version History" button
3. Click "Create Version"
4. Add optional notes
5. Click "Create Version"

**What Gets Saved**:
- All assessment fields
- All risk items and ratings
- All action items
- Current status
- Timestamp and creator

### Viewing Version History

**Access**: Click "Version History" on any assessment

**Timeline View Shows**:
- Version number (incremental)
- Type (Auto or Manual)
- Created date/time
- Created by (user name)
- Status at that version
- Version notes

**Actions Available**:
- 🔍 Compare - View differences
- ↩️ Restore - Revert to this version

### Comparing Versions

**How to Compare**:
1. Go to Version History
2. Click "Compare" on any version
3. Shows side-by-side comparison
4. Highlights all differences

**What's Compared**:
- All assessment fields
- Risk count changes
- Action item count changes
- Field-by-field differences

**Visual Indicators**:
- Red = Old version
- Green = New version
- Differences highlighted

### Restoring Versions

**Process**:
1. View Version History
2. Find version to restore
3. Click "Restore"
4. Confirm restoration
5. System creates backup first
6. Restores all data from that version

**Safety Features**:
- Auto-backup before restore
- Confirmation required
- Audit trail maintained
- Can restore again if needed

**What Gets Restored**:
- Assessment title and details
- Location
- Visit date
- Assessor
- Status
- Risk level
- All custom fields

**What Doesn't Change**:
- Assessment number
- Creation date
- Risk items (separate restore)
- Uploaded photos

---

## 👤 My Activity

### Personal Dashboard

**Access**: Click your name → My Activity

**Shows**:
- Today's actions
- Last 7 days summary
- Last 30 days summary
- Activity breakdown by type
- Recent 50 actions

**Activity Summary**:
- Groups by action + entity type
- Shows count and last occurrence
- Example: "Created Assessment: 15 times"

**Recent Activity Table**:
- Date and time
- Action type (color badge)
- Entity affected
- Change summary

---

## 🔧 Technical Details

### Database Tables

**audit_log**:
- Complete action history
- Before/after values (JSON)
- IP address and user agent
- Session tracking

**assessment_versions**:
- Version snapshots (JSON)
- Version numbering
- Type (auto/manual)
- Creator and timestamp

**user_activity**:
- Page views
- Search queries
- Export actions
- Metadata

**retention_policies**:
- Configurable retention
- Auto-cleanup schedules
- Archive settings

### Automatic Triggers

**Database Triggers**:
```sql
after_assessment_update
- Checks for significant changes
- Auto-creates version if needed
- Captures complete state
```

**PHP Integration**:
```php
logAudit($action, $type, $id, $old, $new, $name);
logActivity($type, $description, $metadata);
```

### Retention Policies

**Default Policies**:
- Audit logs: 2 years (archived after 1 year)
- Versions: 3 years (archived after 2 years)
- User activity: 1 year (archived after 6 months)
- Assessments: 5 years (regulatory requirement)

**Cleanup**:
- Runs automatically
- Only deletes auto-versions
- Manual versions kept indefinitely
- Configurable per entity type

---

## 📋 Use Cases

### Compliance & Auditing

**Scenario**: Annual compliance audit

**Process**:
1. Go to Audit Logs
2. Filter by date range (1 year)
3. Filter by action type
4. Export to CSV
5. Provide to auditors

**Benefits**:
- Complete audit trail
- Who did what when
- All changes documented
- Export ready

### Incident Investigation

**Scenario**: Assessment mysteriously changed

**Process**:
1. Go to assessment
2. Click "Version History"
3. Review timeline
4. Compare versions to see changes
5. Identify who made change
6. Check audit logs for details

**Result**:
- Exact change identified
- User who made it known
- Can restore if needed
- Prevent future issues

### Collaborative Editing

**Scenario**: Multiple people editing assessment

**Process**:
1. Before major edits, create manual version
2. Add notes: "Before QA review"
3. Make changes
4. If problems, restore previous version
5. Compare to see what changed

**Benefits**:
- Safe experimentation
- Easy rollback
- Change tracking
- Accountability

### Training & Quality Control

**Scenario**: Training new assessors

**Process**:
1. Review their audit logs
2. See what they're creating
3. Check version history of assessments
4. Provide feedback based on actual work
5. Track improvement over time

**Metrics**:
- Actions per day
- Types of changes made
- Error rates
- Quality improvements

---

## 🔐 Permissions

### Who Can View Audit Logs?
- Admins: Full access
- Assessors: Own activity only
- Viewers: Own activity only

### Who Can Create Versions?
- Admins: Yes
- Assessors: Yes
- Viewers: No

### Who Can Restore Versions?
- Admins: Yes
- Assessors: Yes (own assessments)
- Viewers: No

### Who Can Export Logs?
- Admins: Yes (all logs)
- Assessors: No
- Viewers: No

---

## 💡 Best Practices

### For Users

**Creating Versions**:
- Before major edits
- Before status changes
- At project milestones
- When unsure about changes

**Adding Notes**:
- Be descriptive
- Mention why version created
- Reference ticket numbers
- Note major changes

**Using History**:
- Review before restoring
- Compare first
- Check who made changes
- Understand context

### For Administrators

**Monitoring**:
- Review audit logs weekly
- Check for unusual patterns
- Monitor failed logins
- Track bulk changes

**Maintenance**:
- Configure retention policies
- Archive old data
- Clean up test versions
- Monitor storage usage

**Training**:
- Show users version control
- Explain audit trail
- Demo restore process
- Set expectations

---

## 🆘 Troubleshooting

### Version Not Created

**Check**:
- User has permission
- Assessment not locked
- Database triggers active
- Sufficient storage

**Solution**:
- Verify permissions
- Unlock assessment
- Check MySQL triggers
- Free up space

### Can't See Audit Logs

**Check**:
- User role (Admin only)
- Audit permission granted
- Logs exist
- Date filters applied

**Solution**:
- Login as admin
- Grant audit permission
- Clear filters
- Check database

### Restore Failed

**Check**:
- Version exists
- User has permission
- Assessment not locked
- Database connection

**Solution**:
- Verify version ID
- Check permissions
- Unlock assessment
- Retry operation

---

## 📈 Statistics & Reporting

### System Activity

**View**: Audit Logs page → Top cards

**Metrics**:
- Total actions (7 days)
- Active users
- Top action type
- Trend graph

### User Performance

**View**: My Activity page

**Metrics**:
- Actions today
- Actions this week
- Actions this month
- Action breakdown

### Version Usage

**View**: Assessment Versions page

**Metrics**:
- Total versions
- Manual vs auto
- Average per assessment
- Storage used

---

## ✅ Checklist

### Setup
- [ ] Database schema imported
- [ ] Audit tables created
- [ ] Triggers installed
- [ ] Permissions configured
- [ ] Retention policies set

### Testing
- [ ] Create action logged
- [ ] Update action logged
- [ ] Delete action logged
- [ ] Login/logout tracked
- [ ] Version created
- [ ] Version restored
- [ ] Compare works
- [ ] Export CSV works

### Training
- [ ] Users know where to find audit logs
- [ ] Users can create versions
- [ ] Users understand restore process
- [ ] Admins can export logs
- [ ] Everyone knows permissions

---

**Feature Status**: ✅ Production Ready  
**Version**: 3.3.0  
**Last Updated**: February 2026

Complete audit trail and version control for enterprise compliance and quality assurance.
