# Quick Start Guide - Risk Assessment System

## ⚡ 5-Minute Installation

This guide will get your Risk Assessment System up and running in 5 minutes.

### Step 1: Extract Files (30 seconds)
```bash
# Extract the system to your web server directory
unzip risk-assessment-system.zip
cd risk-assessment-system
```

### Step 2: Database Setup (1 minute)
```bash
# Option A: Command line
mysql -u root -p < database/schema.sql

# Option B: phpMyAdmin
# 1. Open phpMyAdmin
# 2. Create new database: risk_assessment_db
# 3. Import database/schema.sql
```

### Step 3: Configure Backend (1 minute)
```bash
# Edit backend/config.php
nano backend/config.php

# Update these lines:
define('DB_HOST', 'localhost');      # Your database host
define('DB_NAME', 'risk_assessment_db');  # Database name
define('DB_USER', 'your_username');  # Your MySQL username
define('DB_PASS', 'your_password');  # Your MySQL password

# Save and close (Ctrl+X, Y, Enter)
```

### Step 4: Set Permissions (30 seconds)
```bash
# Make uploads directory writable
chmod 755 backend/uploads

# For Linux/Mac
chmod -R 755 .
chown -R www-data:www-data .  # Or your web server user
```

### Step 5: Frontend Setup (2 minutes)
```bash
# Navigate to frontend
cd frontend

# Install dependencies
npm install

# Update API URL in src/App.jsx (line ~40)
# Change: static baseURL = 'http://your-domain.com/api';

# Build for production
npm run build

# Copy build files to web root
cp -r build/* ../public/
```

### Step 6: Web Server Setup (1 minute)

**Apache Users:**
```bash
# Copy .htaccess to web root
cp .htaccess /var/www/html/

# Ensure mod_rewrite is enabled
sudo a2enmod rewrite
sudo service apache2 restart
```

**Nginx Users:**
Add to your nginx config:
```nginx
location /api {
    try_files $uri $uri/ /backend/api/index.php?$query_string;
    include fastcgi_params;
    fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
    fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
}

location / {
    try_files $uri $uri/ /index.html;
}
```

### Step 7: Access the System (10 seconds)
Open your browser and navigate to:
```
http://your-domain.com
```

**Default Login:**
- Username: `admin`
- Password: `admin123`

⚠️ **IMPORTANT: Change this password immediately!**

---

## 🔧 Development Mode (Alternative)

For development/testing without building:

### Terminal 1 - Backend
```bash
# Start PHP built-in server
cd backend
php -S localhost:8000 -t .
```

### Terminal 2 - Frontend
```bash
# Start React dev server
cd frontend
npm start
```

Visit: `http://localhost:3000`

---

## ✅ Verify Installation

### Test Database Connection
```bash
php backend/test-connection.php
```

### Test API
```bash
curl http://your-domain.com/api/settings
```

### Check Logs
```bash
tail -f backend/logs/error.log
```

---

## 🎯 Post-Installation

### 1. Change Admin Password
1. Log in as admin
2. Go to Settings → Profile
3. Change password
4. Save

### 2. Create Users
1. Go to Settings → Users
2. Click "Add User"
3. Assign appropriate roles

### 3. Add Locations
1. Go to Locations
2. Click "Add Location"
3. Enter location details

### 4. Configure System
1. Go to Settings → System
2. Update company name
3. Upload logo
4. Set preferences

---

## 🚨 Troubleshooting

### Database Connection Failed
```bash
# Check MySQL is running
sudo service mysql status

# Test connection
mysql -u your_username -p

# Verify credentials in config.php
```

### API Returns 404
```bash
# Check .htaccess exists
ls -la .htaccess

# Test mod_rewrite
apache2ctl -M | grep rewrite

# Check API file exists
ls -la backend/api/index.php
```

### Frontend Shows Blank Page
```bash
# Check console for errors (F12)
# Verify API URL is correct
# Check CORS settings
# Clear browser cache
```

### Permission Denied
```bash
# Fix permissions
sudo chmod -R 755 .
sudo chown -R www-data:www-data .
chmod 755 backend/uploads
```

### Can't Install npm Packages
```bash
# Update npm
npm install -g npm@latest

# Clear npm cache
npm cache clean --force

# Try again
npm install
```

---

## 📦 Directory Structure After Installation

```
your-web-root/
├── backend/
│   ├── api/
│   ├── controllers/
│   ├── uploads/
│   ├── config.php
│   └── ...
├── public/          # Built React app
│   ├── static/
│   ├── index.html
│   └── manifest.json
├── database/
│   └── schema.sql
├── docs/
│   └── README.md
└── .htaccess
```

---

## 🔐 Security Checklist

- [ ] Changed default admin password
- [ ] Updated JWT_SECRET in config.php
- [ ] Set proper file permissions
- [ ] Configured HTTPS/SSL
- [ ] Updated CORS settings
- [ ] Disabled PHP display_errors
- [ ] Set up database backups
- [ ] Configured firewall

---

## 📞 Need Help?

### Common Commands

**Restart Services:**
```bash
# Apache
sudo service apache2 restart

# MySQL
sudo service mysql restart

# Nginx
sudo service nginx restart
```

**View Logs:**
```bash
# Apache error log
tail -f /var/log/apache2/error.log

# MySQL log
tail -f /var/log/mysql/error.log

# Application log
tail -f backend/logs/error.log
```

**Database Backup:**
```bash
mysqldump -u root -p risk_assessment_db > backup.sql
```

**Database Restore:**
```bash
mysql -u root -p risk_assessment_db < backup.sql
```

---

## 🎉 You're All Set!

Your Risk Assessment System is now ready to use. 

**Next Steps:**
1. ✅ Log in with admin credentials
2. ✅ Change admin password
3. ✅ Create your first location
4. ✅ Create your first assessment
5. ✅ Invite team members

**Resources:**
- Full Documentation: `docs/README.md`
- API Reference: `docs/API.md`
- Troubleshooting: `docs/TROUBLESHOOTING.md`

---

**Installation Support:**
- Check the documentation
- Review error logs
- Verify all prerequisites are met
- Ensure proper file permissions

**Happy Assessing! 🎯**
