<?php
// Get custom settings
function getCustomLogo($pdo) {
    try {
        $stmt = $pdo->prepare("SELECT setting_value FROM system_settings WHERE setting_key = 'logo_filename'");
        $stmt->execute();
        $result = $stmt->fetch();
        
        if ($result && file_exists(__DIR__ . '/../public/uploads/branding/' . $result['setting_value'])) {
            return 'uploads/branding/' . $result['setting_value'];
        }
    } catch (Exception $e) {
        // Table might not exist yet
    }
    return null;
}

function getSystemName($pdo) {
    try {
        $stmt = $pdo->prepare("SELECT setting_value FROM system_settings WHERE setting_key = 'system_name'");
        $stmt->execute();
        $result = $stmt->fetch();
        return $result ? $result['setting_value'] : 'Risk Assessment';
    } catch (Exception $e) {
        return 'Risk Assessment';
    }
}

$customLogo = getCustomLogo($pdo);
$systemName = getSystemName($pdo);
?>
<header class="header">
    <nav class="nav-container">
        <a href="dashboard.php" class="logo">
            <?php if ($customLogo): ?>
                <img src="<?php echo $customLogo; ?>" alt="<?php echo sanitizeOutput($systemName); ?>" 
                     style="max-height: 40px; max-width: 200px; object-fit: contain;">
            <?php else: ?>
                <div class="logo-icon">⚠️</div>
                <span><?php echo sanitizeOutput($systemName); ?></span>
            <?php endif; ?>
        </a>

        <ul class="nav-menu">
            <li><a href="dashboard.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>">📊 Dashboard</a></li>
            <li><a href="assessments.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'assessments.php' ? 'active' : ''; ?>">📋 Assessments</a></li>
            <li><a href="new-assessment.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'new-assessment.php' ? 'active' : ''; ?>">➕ New Assessment</a></li>
            <li><a href="locations.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'locations.php' ? 'active' : ''; ?>">📍 Locations</a></li>
            <?php if ($_SESSION['role'] === 'admin'): ?>
            <li><a href="admin-panel.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'admin-panel.php' ? 'active' : ''; ?>" style="background: rgba(217, 119, 6, 0.1); font-weight: 600;">⚙️ Admin Panel</a></li>
            <li><a href="users.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : ''; ?>">👥 Users</a></li>
            <?php endif; ?>
        </ul>

        <div class="user-info">
            <div class="user-avatar"><?php echo strtoupper(substr($_SESSION['full_name'], 0, 1)); ?></div>
            <div>
                <div style="font-weight: 600; color: var(--text-primary);"><?php echo sanitizeOutput($_SESSION['full_name']); ?></div>
                <div style="font-size: 0.85rem;"><?php echo ucfirst($_SESSION['role']); ?></div>
            </div>
            <a href="logout.php" class="btn btn-secondary" style="margin-left: 1rem; padding: 0.5rem 1rem;">🚪 Logout</a>
        </div>
    </nav>
</header>
