<?php
/**
 * Emergency Password Reset
 * Delete this file after use for security!
 */

$resetComplete = false;
$error = '';
$newPassword = '';

// Process reset
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reset'])) {
    require_once '../includes/config.php';
    
    $newPassword = $_POST['password'] ?? 'Admin123!';
    $hash = password_hash($newPassword, PASSWORD_DEFAULT);
    
    try {
        // Check if admin exists
        $stmt = $pdo->prepare("SELECT id FROM users WHERE username = 'admin'");
        $stmt->execute();
        $admin = $stmt->fetch();
        
        if ($admin) {
            // Update password
            $stmt = $pdo->prepare("UPDATE users SET password_hash = ? WHERE username = 'admin'");
            $stmt->execute([$hash]);
        } else {
            // Create admin user
            $stmt = $pdo->prepare("
                INSERT INTO users (username, email, password_hash, full_name, role) 
                VALUES ('admin', 'admin@example.com', ?, 'System Administrator', 'admin')
            ");
            $stmt->execute([$hash]);
        }
        
        $resetComplete = true;
    } catch (PDOException $e) {
        $error = 'Database error: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Emergency Password Reset</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 500px;
            width: 100%;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
        }
        .warning {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
            color: #856404;
        }
        .success {
            background: #d4edda;
            border-left: 4px solid #28a745;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
            color: #155724;
        }
        .error {
            background: #f8d7da;
            border-left: 4px solid #dc3545;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
            color: #721c24;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #555;
        }
        input[type="password"],
        input[type="text"] {
            width: 100%;
            padding: 12px;
            border: 2px solid #ddd;
            border-radius: 6px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        input:focus {
            outline: none;
            border-color: #667eea;
        }
        button {
            width: 100%;
            padding: 14px;
            background: #667eea;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s;
        }
        button:hover {
            background: #5568d3;
        }
        .btn-secondary {
            background: #6c757d;
            margin-top: 10px;
        }
        .btn-secondary:hover {
            background: #5a6268;
        }
        .btn-danger {
            background: #dc3545;
        }
        .btn-danger:hover {
            background: #c82333;
        }
        .info {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 6px;
            margin: 20px 0;
            font-family: monospace;
        }
        .code {
            background: #f8f9fa;
            padding: 10px;
            border-radius: 4px;
            font-family: monospace;
            margin: 10px 0;
            display: block;
        }
        ul {
            margin-left: 20px;
            color: #555;
        }
        li {
            margin: 8px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <?php if (!$resetComplete): ?>
            <h1>🔐 Emergency Password Reset</h1>
            
            <div class="warning">
                <strong>⚠️ Security Notice:</strong> Delete this file (reset-admin.php) immediately after use! Leaving it accessible is a serious security risk.
            </div>

            <?php if ($error): ?>
                <div class="error">
                    <strong>Error:</strong> <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="form-group">
                    <label for="password">New Admin Password</label>
                    <input type="text" id="password" name="password" 
                           value="Admin123!" 
                           placeholder="Enter new password" 
                           required>
                    <small style="color: #666; display: block; margin-top: 5px;">
                        Leave as "Admin123!" for default password
                    </small>
                </div>

                <button type="submit" name="reset">Reset Admin Password</button>
            </form>

            <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #ddd;">
                <h3 style="color: #555; margin-bottom: 10px;">What this does:</h3>
                <ul>
                    <li>Resets the admin user password</li>
                    <li>Creates admin user if it doesn't exist</li>
                    <li>Allows you to login immediately</li>
                </ul>
            </div>

        <?php else: ?>
            <h1>✅ Password Reset Successful!</h1>
            
            <div class="success">
                Admin password has been reset successfully!
            </div>

            <div class="info">
                <strong>Login Credentials:</strong><br>
                Username: <strong>admin</strong><br>
                Password: <strong><?php echo htmlspecialchars($newPassword); ?></strong>
            </div>

            <div class="warning">
                <strong>Important Steps:</strong>
                <ol style="margin-left: 20px; margin-top: 10px;">
                    <li>Login with the credentials above</li>
                    <li>Change the password immediately</li>
                    <li><strong>DELETE THIS FILE NOW!</strong></li>
                </ol>
            </div>

            <a href="login.php">
                <button type="button">Go to Login Page</button>
            </a>

            <div style="margin-top: 20px; padding: 15px; background: #fff3cd; border-radius: 6px;">
                <strong>🗑️ To delete this file:</strong>
                <div class="code">rm /path/to/public/reset-admin.php</div>
                Or delete via FTP/cPanel file manager
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
