<?php
require_once '../includes/config.php';

if (isLoggedIn()) {
    // Log the logout
    try {
        $stmt = $pdo->prepare("INSERT INTO audit_log (user_id, action, ip_address, user_agent) VALUES (?, 'logout', ?, ?)");
        $stmt->execute([$_SESSION['user_id'], $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']]);
    } catch (PDOException $e) {
        error_log($e->getMessage());
    }
}

// Clear session
session_unset();
session_destroy();

// Redirect to login
header('Location: login.php');
exit;
?>
