<?php
require_once '../includes/config.php';
requireLogin();

// Fetch all locations
$stmt = $pdo->query("SELECT * FROM locations ORDER BY location_name");
$locations = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Locations - Risk Assessment System</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        .location-card {
            background: var(--bg-tertiary);
            padding: 1.5rem;
            border-radius: 8px;
            margin-bottom: 1rem;
            border: 1px solid var(--border-color);
        }
        
        .location-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1rem;
        }
        
        .location-info {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            color: var(--text-secondary);
            font-size: 0.95rem;
        }
        
        .info-item {
            display: flex;
            align-items: flex-start;
            gap: 0.5rem;
        }
        
        .info-label {
            font-weight: 600;
            color: var(--text-primary);
        }
        
        .coordinates-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.25rem 0.75rem;
            background: rgba(217, 119, 6, 0.2);
            border-radius: 4px;
            font-family: var(--font-mono);
            font-size: 0.85rem;
        }
        
        .what3words-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.25rem 0.75rem;
            background: rgba(220, 38, 38, 0.2);
            border-radius: 4px;
            font-weight: 600;
            color: #F87171;
        }
    </style>
</head>
<body>
    <?php include '../templates/header.php'; ?>

    <div class="container">
        <div class="page-header">
            <div>
                <h1 class="page-title">Delivery Locations</h1>
                <p class="page-subtitle">Manage supermarket delivery points</p>
            </div>
            <a href="add-location.php" class="btn btn-primary">➕ Add Location</a>
        </div>

        <?php if (empty($locations)): ?>
            <div class="card text-center" style="padding: 4rem 2rem;">
                <div style="font-size: 4rem; margin-bottom: 1rem;">📍</div>
                <h3 style="margin-bottom: 1rem;">No Locations Added Yet</h3>
                <p style="color: var(--text-muted); margin-bottom: 2rem;">
                    Start by adding your first delivery location to begin conducting risk assessments.
                </p>
                <a href="add-location.php" class="btn btn-primary">Add Your First Location</a>
            </div>
        <?php else: ?>
            <div class="stats-grid" style="margin-bottom: 2rem;">
                <div class="stat-card primary">
                    <div class="stat-value"><?php echo count($locations); ?></div>
                    <div class="stat-label">Total Locations</div>
                </div>
                <div class="stat-card success">
                    <div class="stat-value">
                        <?php 
                        $with_gps = array_filter($locations, fn($loc) => !empty($loc['latitude']) && !empty($loc['longitude']));
                        echo count($with_gps); 
                        ?>
                    </div>
                    <div class="stat-label">With GPS Coordinates</div>
                </div>
                <div class="stat-card info">
                    <div class="stat-value">
                        <?php 
                        $with_w3w = array_filter($locations, fn($loc) => !empty($loc['what3words']));
                        echo count($with_w3w); 
                        ?>
                    </div>
                    <div class="stat-label">With What3Words</div>
                </div>
            </div>

            <?php foreach ($locations as $location): 
                $opening_hours = json_decode($location['opening_hours'], true);
                $delivery_windows = json_decode($location['delivery_windows'], true);
            ?>
                <div class="location-card">
                    <div class="location-header">
                        <div>
                            <h3 style="color: var(--primary); font-size: 1.3rem; margin-bottom: 0.5rem;">
                                📍 <?php echo sanitizeOutput($location['location_name']); ?>
                            </h3>
                            <p style="color: var(--text-muted);">
                                <?php echo sanitizeOutput($location['address_line1']); ?>
                                <?php if ($location['address_line2']): ?>, <?php echo sanitizeOutput($location['address_line2']); ?><?php endif; ?>
                            </p>
                            <p style="color: var(--text-muted);">
                                <?php echo sanitizeOutput($location['city'] . ', ' . $location['postcode']); ?>
                            </p>
                        </div>
                        <div class="btn-group" style="gap: 0.5rem;">
                            <a href="view-location.php?id=<?php echo $location['id']; ?>" class="btn btn-secondary">👁️ View</a>
                            <a href="edit-location.php?id=<?php echo $location['id']; ?>" class="btn btn-secondary">✏️ Edit</a>
                        </div>
                    </div>

                    <div class="location-info">
                        <?php if ($location['contact_name']): ?>
                        <div class="info-item">
                            <span class="info-label">Contact:</span>
                            <span><?php echo sanitizeOutput($location['contact_name']); ?></span>
                        </div>
                        <?php endif; ?>

                        <?php if ($location['contact_phone']): ?>
                        <div class="info-item">
                            <span class="info-label">Phone:</span>
                            <span><?php echo sanitizeOutput($location['contact_phone']); ?></span>
                        </div>
                        <?php endif; ?>

                        <?php if ($location['latitude'] && $location['longitude']): ?>
                        <div class="info-item">
                            <span class="info-label">GPS:</span>
                            <span class="coordinates-badge">
                                📍 <?php echo number_format($location['latitude'], 6); ?>, <?php echo number_format($location['longitude'], 6); ?>
                            </span>
                        </div>
                        <?php endif; ?>

                        <?php if ($location['what3words']): ?>
                        <div class="info-item">
                            <span class="info-label">What3Words:</span>
                            <a href="https://what3words.com/<?php echo urlencode($location['what3words']); ?>" 
                               target="_blank" class="what3words-badge">
                                //<?php echo sanitizeOutput($location['what3words']); ?>
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>

                    <?php if ($opening_hours): ?>
                    <div style="margin-top: 1rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
                        <strong style="color: var(--text-primary);">🕐 Opening Hours:</strong>
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 0.5rem; margin-top: 0.5rem;">
                            <?php foreach ($opening_hours as $day => $hours): ?>
                                <div style="color: var(--text-secondary); font-size: 0.9rem;">
                                    <strong><?php echo ucfirst($day); ?>:</strong> <?php echo $hours['open'] ?? 'Closed'; ?>
                                    <?php if (!empty($hours['close'])): ?> - <?php echo $hours['close']; ?><?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if ($delivery_windows): ?>
                    <div style="margin-top: 1rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
                        <strong style="color: var(--text-primary);">🚚 Delivery Windows:</strong>
                        <div style="display: flex; gap: 0.5rem; margin-top: 0.5rem; flex-wrap: wrap;">
                            <?php foreach ($delivery_windows as $window): ?>
                                <span class="badge" style="background: rgba(5, 150, 105, 0.2); color: #10B981;">
                                    <?php echo sanitizeOutput($window['start'] . ' - ' . $window['end']); ?>
                                    <?php if (!empty($window['days'])): ?>(<?php echo sanitizeOutput($window['days']); ?>)<?php endif; ?>
                                </span>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if ($location['google_maps_url']): ?>
                    <div style="margin-top: 1rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
                        <a href="<?php echo sanitizeOutput($location['google_maps_url']); ?>" 
                           target="_blank" 
                           class="btn btn-secondary"
                           style="display: inline-flex; align-items: center; gap: 0.5rem;">
                            🗺️ Open in Google Maps
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <script src="js/app.js"></script>
</body>
</html>
