<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation - Risk Assessment System</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="container" style="max-width: 800px; margin: 4rem auto;">
        <div class="card">
            <div style="text-align: center; margin-bottom: 3rem;">
                <div style="width: 100px; height: 100px; margin: 0 auto 1.5rem; background: linear-gradient(135deg, var(--primary) 0%, var(--warning) 100%); border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 3rem;">
                    ⚠️
                </div>
                <h1 class="page-title">Risk Assessment System</h1>
                <p class="page-subtitle">Installation & Setup Guide</p>
            </div>

            <div style="background: var(--bg-tertiary); padding: 2rem; border-radius: 8px; margin-bottom: 2rem;">
                <h2 style="color: var(--primary); margin-bottom: 1rem;">📋 Installation Steps</h2>
                
                <ol style="color: var(--text-secondary); line-height: 2; padding-left: 1.5rem;">
                    <li><strong>Create Database:</strong>
                        <pre style="background: var(--bg-secondary); padding: 1rem; border-radius: 6px; margin: 0.5rem 0; overflow-x: auto;">mysql -u scubatricky_risk -p
CREATE DATABASE scubatricky_risk CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
GRANT ALL PRIVILEGES ON scubatricky_risk.* TO 'scubatricky_risk'@'localhost';
FLUSH PRIVILEGES;
exit;</pre>
                    </li>

                    <li><strong>Import Database Schema:</strong>
                        <pre style="background: var(--bg-secondary); padding: 1rem; border-radius: 6px; margin: 0.5rem 0; overflow-x: auto;">mysql -u scubatricky_risk -p scubatricky_risk < includes/schema.sql</pre>
                    </li>

                    <li><strong>Configure Database Connection:</strong><br>
                        Edit <code>includes/config.php</code> with your database credentials
                    </li>

                    <li><strong>Set Directory Permissions:</strong>
                        <pre style="background: var(--bg-secondary); padding: 1rem; border-radius: 6px; margin: 0.5rem 0; overflow-x: auto;">chmod 755 reports/
chown www-data:www-data reports/
chmod +x public/api/generate_pdf.py</pre>
                    </li>

                    <li><strong>Install Python Dependencies:</strong>
                        <pre style="background: var(--bg-secondary); padding: 1rem; border-radius: 6px; margin: 0.5rem 0; overflow-x: auto;">pip3 install reportlab --break-system-packages</pre>
                    </li>

                    <li><strong>Test Installation:</strong><br>
                        Reload this page. If setup is complete, you'll be redirected to the login page.
                    </li>
                </ol>
            </div>

            <div style="background: rgba(217, 119, 6, 0.1); border-left: 4px solid var(--primary); padding: 1.5rem; border-radius: 6px; margin-bottom: 2rem;">
                <h3 style="color: var(--primary); margin-bottom: 1rem;">🔐 Default Login Credentials</h3>
                <p style="color: var(--text-secondary); margin: 0;">
                    <strong>Username:</strong> <code>admin</code><br>
                    <strong>Password:</strong> <code>Admin123!</code>
                </p>
                <p style="color: var(--warning); margin-top: 1rem; font-size: 0.9rem;">
                    ⚠️ Change the default password immediately after first login!
                </p>
            </div>

            <div style="background: var(--bg-tertiary); padding: 2rem; border-radius: 8px; margin-bottom: 2rem;">
                <h3 style="color: var(--primary); margin-bottom: 1rem;">✅ Requirements Checklist</h3>
                
                <div style="color: var(--text-secondary);">
                    <div style="padding: 0.75rem; border-bottom: 1px solid var(--border-color);">
                        ✓ PHP 7.4 or higher with PDO extension
                    </div>
                    <div style="padding: 0.75rem; border-bottom: 1px solid var(--border-color);">
                        ✓ MySQL 5.7+ or MariaDB 10.3+
                    </div>
                    <div style="padding: 0.75rem; border-bottom: 1px solid var(--border-color);">
                        ✓ Python 3.7+ with ReportLab
                    </div>
                    <div style="padding: 0.75rem; border-bottom: 1px solid var(--border-color);">
                        ✓ Apache/Nginx web server
                    </div>
                    <div style="padding: 0.75rem;">
                        ✓ Write permissions on reports/ directory
                    </div>
                </div>
            </div>

            <div class="btn-group" style="justify-content: center;">
                <button onclick="location.reload()" class="btn btn-primary">
                    🔄 Test Installation
                </button>
                <a href="README.md" class="btn btn-secondary" target="_blank">
                    📖 Read Full Documentation
                </a>
            </div>

            <div style="text-align: center; margin-top: 3rem; padding-top: 2rem; border-top: 1px solid var(--border-color); color: var(--text-muted); font-size: 0.9rem;">
                <p>Need help? Check the <strong>README.md</strong> file for detailed instructions and troubleshooting.</p>
            </div>
        </div>
    </div>
</body>
</html>
