<?php
/**
 * Risk Assessment System - Entry Point
 * Redirects to appropriate page based on authentication status
 */

require_once '../includes/config.php';

// Check if database is set up
try {
    $pdo->query("SELECT 1 FROM users LIMIT 1");
    $db_ready = true;
} catch (PDOException $e) {
    $db_ready = false;
}

if (!$db_ready) {
    // Database not set up - redirect to installation
    header('Location: install.php');
    exit;
}

// Check if user is logged in
if (isLoggedIn()) {
    // Redirect to dashboard
    header('Location: dashboard.php');
} else {
    // Redirect to login
    header('Location: login.php');
}
exit;
?>
