<?php
/**
 * Print Report Viewer
 * Opens HTML report in new window for printing/PDF saving
 */

require_once '../../includes/config.php';
requireLogin();

if (!isset($_GET['file'])) {
    die('File not specified');
}

$filename = basename($_GET['file']); // Prevent directory traversal
$filepath = __DIR__ . '/../../reports/' . $filename;

// Verify file exists
if (!file_exists($filepath)) {
    http_response_code(404);
    die('File not found');
}

// Verify it's an HTML file
if (pathinfo($filename, PATHINFO_EXTENSION) !== 'html') {
    http_response_code(403);
    die('Invalid file type');
}

// Serve the HTML file
header('Content-Type: text/html; charset=utf-8');
readfile($filepath);
exit;
