<?php
require_once '../includes/config.php';
requireLogin();

// Only admins can access
if ($_SESSION['role'] !== 'admin') {
    header('Location: dashboard.php');
    exit;
}

// Get statistics
$stats = [];

// Total users
$stmt = $pdo->query("SELECT COUNT(*) FROM users");
$stats['total_users'] = $stmt->fetchColumn();

// Active users
$stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE is_active = 1");
$stats['active_users'] = $stmt->fetchColumn();

// Total locations
$stmt = $pdo->query("SELECT COUNT(*) FROM locations");
$stats['total_locations'] = $stmt->fetchColumn();

// Total assessments
$stmt = $pdo->query("SELECT COUNT(*) FROM assessments");
$stats['total_assessments'] = $stmt->fetchColumn();

// Custom fields count
$stmt = $pdo->query("SELECT COUNT(*) FROM custom_field_definitions WHERE is_active = 1");
$stats['custom_fields'] = $stmt->fetchColumn();

// Vehicle types count
$stmt = $pdo->query("SELECT COUNT(*) FROM vehicle_types WHERE is_active = 1");
$stats['vehicle_types'] = $stmt->fetchColumn();

// Photos count
$stmt = $pdo->query("SELECT COUNT(*) FROM photos");
$stats['total_photos'] = $stmt->fetchColumn();

// Recent activity
$stmt = $pdo->query("
    SELECT u.username, u.last_login 
    FROM users u 
    WHERE u.last_login IS NOT NULL 
    ORDER BY u.last_login DESC 
    LIMIT 5
");
$recent_logins = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Risk System</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        .admin-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .admin-card {
            background: var(--bg-card);
            border-radius: 12px;
            padding: 1.5rem;
            border: 1px solid var(--border-color);
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .admin-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 16px rgba(0,0,0,0.1);
            border-color: var(--primary);
        }
        
        .admin-card-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
            display: block;
        }
        
        .admin-card-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 0.5rem;
        }
        
        .admin-card-description {
            color: var(--text-secondary);
            font-size: 0.9rem;
            margin-bottom: 1rem;
            line-height: 1.6;
        }
        
        .admin-card-stat {
            display: inline-block;
            background: var(--bg-tertiary);
            padding: 0.5rem 1rem;
            border-radius: 6px;
            font-weight: 600;
            color: var(--primary);
        }
        
        .stats-overview {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }
        
        .stat-box {
            background: linear-gradient(135deg, var(--primary) 0%, #5a67d8 100%);
            color: white;
            padding: 1.5rem;
            border-radius: 12px;
            text-align: center;
        }
        
        .stat-value {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .stat-label {
            font-size: 0.9rem;
            opacity: 0.9;
        }
        
        .recent-activity {
            background: var(--bg-card);
            border-radius: 12px;
            padding: 1.5rem;
            border: 1px solid var(--border-color);
        }
        
        .activity-item {
            padding: 0.75rem 0;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .activity-item:last-child {
            border-bottom: none;
        }
    </style>
</head>
<body>
    <?php include '../templates/header.php'; ?>

    <div class="container">
        <div class="page-header">
            <div>
                <h1 class="page-title">⚙️ Admin Panel</h1>
                <p class="page-subtitle">System configuration and management</p>
            </div>
        </div>

        <!-- Statistics Overview -->
        <div class="stats-overview">
            <div class="stat-box">
                <div class="stat-value"><?php echo $stats['active_users']; ?></div>
                <div class="stat-label">Active Users</div>
            </div>
            <div class="stat-box" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%);">
                <div class="stat-value"><?php echo $stats['total_locations']; ?></div>
                <div class="stat-label">Locations</div>
            </div>
            <div class="stat-box" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);">
                <div class="stat-value"><?php echo $stats['total_assessments']; ?></div>
                <div class="stat-label">Assessments</div>
            </div>
            <div class="stat-box" style="background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);">
                <div class="stat-value"><?php echo $stats['total_photos']; ?></div>
                <div class="stat-label">Photos</div>
            </div>
        </div>

        <!-- Admin Functions -->
        <h2 style="color: var(--text-primary); margin-bottom: 1.5rem; font-size: 1.5rem;">
            🛠️ Admin Functions
        </h2>

        <div class="admin-grid">
            <!-- User Management -->
            <div class="admin-card" onclick="window.location.href='users.php'">
                <span class="admin-card-icon">👥</span>
                <h3 class="admin-card-title">User Management</h3>
                <p class="admin-card-description">
                    Create, edit, and manage user accounts. Set roles and permissions for system access.
                </p>
                <div class="admin-card-stat">
                    <?php echo $stats['total_users']; ?> users
                </div>
            </div>

            <!-- Custom Fields -->
            <div class="admin-card" onclick="window.location.href='custom-fields.php'">
                <span class="admin-card-icon">⚙️</span>
                <h3 class="admin-card-title">Custom Fields</h3>
                <p class="admin-card-description">
                    Configure additional fields for locations. Add custom data points specific to your operations.
                </p>
                <div class="admin-card-stat">
                    <?php echo $stats['custom_fields']; ?> active fields
                </div>
            </div>

            <!-- Vehicle Configuration -->
            <div class="admin-card" onclick="window.location.href='vehicle-config.php'">
                <span class="admin-card-icon">🚚</span>
                <h3 class="admin-card-title">Vehicle Types & Volumes</h3>
                <p class="admin-card-description">
                    Manage vehicle types and delivery volumes used in assessments. Customize to match your fleet.
                </p>
                <div class="admin-card-stat">
                    <?php echo $stats['vehicle_types']; ?> vehicle types
                </div>
            </div>

            <!-- Risk Categories -->
            <div class="admin-card" onclick="window.location.href='risk-categories.php'">
                <span class="admin-card-icon">⚠️</span>
                <h3 class="admin-card-title">Risk Categories</h3>
                <p class="admin-card-description">
                    Configure risk categories and items used in assessments. Customize safety criteria.
                </p>
                <div class="admin-card-stat">
                    Manage categories
                </div>
            </div>

            <!-- PDF Templates -->
            <div class="admin-card" onclick="window.location.href='pdf-templates.php'">
                <span class="admin-card-icon">📄</span>
                <h3 class="admin-card-title">PDF Templates</h3>
                <p class="admin-card-description">
                    Design custom PDF report templates. Drag-and-drop fields to create professional exports.
                </p>
                <div class="admin-card-stat">
                    <?php
                    $stmt = $pdo->query("SELECT COUNT(*) FROM pdf_templates WHERE is_active = 1");
                    echo $stmt->fetchColumn();
                    ?> templates
                </div>
            </div>

            <!-- Location Management -->
            <div class="admin-card" onclick="window.location.href='locations.php'">
                <span class="admin-card-icon">📍</span>
                <h3 class="admin-card-title">All Locations</h3>
                <p class="admin-card-description">
                    View and manage all delivery locations. Edit details, custom fields, and GPS coordinates.
                </p>
                <div class="admin-card-stat">
                    <?php echo $stats['total_locations']; ?> locations
                </div>
            </div>

            <!-- Assessment Reports -->
            <div class="admin-card" onclick="window.location.href='assessments.php'">
                <span class="admin-card-icon">📋</span>
                <h3 class="admin-card-title">All Assessments</h3>
                <p class="admin-card-description">
                    View all risk assessments. Filter by status, location, or risk level for analysis.
                </p>
                <div class="admin-card-stat">
                    <?php echo $stats['total_assessments']; ?> assessments
                </div>
            </div>

            <!-- System Settings -->
            <div class="admin-card" onclick="window.location.href='system-settings.php'">
                <span class="admin-card-icon">🔧</span>
                <h3 class="admin-card-title">System Settings</h3>
                <p class="admin-card-description">
                    Configure system-wide settings, database backup, and application preferences.
                </p>
                <div class="admin-card-stat">
                    Configure
                </div>
            </div>

            <!-- System Customization -->
            <div class="admin-card" onclick="window.location.href='system-customization.php'">
                <span class="admin-card-icon">🎨</span>
                <h3 class="admin-card-title">System Customization</h3>
                <p class="admin-card-description">
                    Customize colors, upload logo, and personalize the system appearance.
                </p>
                <div class="admin-card-stat">
                    Customize
                </div>
            </div>

            <!-- Reports & Analytics -->
            <div class="admin-card" onclick="window.location.href='reports.php'">
                <span class="admin-card-icon">📊</span>
                <h3 class="admin-card-title">Reports & Analytics</h3>
                <p class="admin-card-description">
                    Generate reports and view analytics on assessments, locations, and risk trends.
                </p>
                <div class="admin-card-stat">
                    View reports
                </div>
            </div>

            <!-- API Documentation -->
            <div class="admin-card" onclick="window.open('API_SETUP.md', '_blank')">
                <span class="admin-card-icon">📚</span>
                <h3 class="admin-card-title">API Documentation</h3>
                <p class="admin-card-description">
                    View API setup guides and integration documentation for external systems.
                </p>
                <div class="admin-card-stat">
                    View docs
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <h2 style="color: var(--text-primary); margin: 2rem 0 1rem 0; font-size: 1.5rem;">
            📈 Recent Activity
        </h2>

        <div class="recent-activity">
            <h3 style="color: var(--text-primary); margin-bottom: 1rem; font-size: 1.1rem;">
                Recent Logins
            </h3>
            <?php if (empty($recent_logins)): ?>
                <p style="color: var(--text-muted); padding: 1rem 0;">No recent activity</p>
            <?php else: ?>
                <?php foreach ($recent_logins as $login): ?>
                    <div class="activity-item">
                        <div>
                            <strong style="color: var(--text-primary);">
                                <?php echo sanitizeOutput($login['username']); ?>
                            </strong>
                            <span style="color: var(--text-muted); font-size: 0.9rem;">
                                logged in
                            </span>
                        </div>
                        <div style="color: var(--text-muted); font-size: 0.85rem;">
                            <?php echo date('d/m/Y H:i', strtotime($login['last_login'])); ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <!-- Quick Links -->
        <div style="margin-top: 2rem; padding: 1.5rem; background: var(--bg-tertiary); border-radius: 12px;">
            <h3 style="color: var(--text-primary); margin-bottom: 1rem; font-size: 1.1rem;">
                📖 Documentation & Guides
            </h3>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem;">
                <a href="../README.md" target="_blank" style="color: var(--primary); text-decoration: none; display: flex; align-items: center; gap: 0.5rem;">
                    📄 <span>System Overview</span>
                </a>
                <a href="../CUSTOM_FIELDS_GUIDE.md" target="_blank" style="color: var(--primary); text-decoration: none; display: flex; align-items: center; gap: 0.5rem;">
                    📄 <span>Custom Fields Guide</span>
                </a>
                <a href="../VEHICLE_CONFIG_GUIDE.md" target="_blank" style="color: var(--primary); text-decoration: none; display: flex; align-items: center; gap: 0.5rem;">
                    📄 <span>Vehicle Config Guide</span>
                </a>
                <a href="../PHOTO_UPLOAD_GUIDE.md" target="_blank" style="color: var(--primary); text-decoration: none; display: flex; align-items: center; gap: 0.5rem;">
                    📄 <span>Photo Upload Guide</span>
                </a>
                <a href="../DEPLOYMENT.md" target="_blank" style="color: var(--primary); text-decoration: none; display: flex; align-items: center; gap: 0.5rem;">
                    📄 <span>Deployment Guide</span>
                </a>
                <a href="../LOGIN_TROUBLESHOOTING.md" target="_blank" style="color: var(--primary); text-decoration: none; display: flex; align-items: center; gap: 0.5rem;">
                    📄 <span>Login Troubleshooting</span>
                </a>
            </div>
        </div>
    </div>

    <script src="js/app.js"></script>
</body>
</html>
