<?php
/**
 * Password Reset Utility
 * Use this to reset the admin password or create password hashes
 */

// Standalone script - include database config
require_once __DIR__ . '/config.php';

echo "===========================================\n";
echo "  Risk Assessment - Password Reset Tool  \n";
echo "===========================================\n\n";

if (php_sapi_name() !== 'cli') {
    die("This script must be run from the command line.\n");
}

// Function to reset admin password
function resetAdminPassword($pdo, $newPassword) {
    $hash = password_hash($newPassword, PASSWORD_DEFAULT);
    
    try {
        // Check if admin user exists
        $stmt = $pdo->prepare("SELECT id FROM users WHERE username = 'admin'");
        $stmt->execute();
        $admin = $stmt->fetch();
        
        if ($admin) {
            // Update existing admin
            $stmt = $pdo->prepare("UPDATE users SET password_hash = ? WHERE username = 'admin'");
            $stmt->execute([$hash]);
            echo "✓ Admin password updated successfully!\n";
        } else {
            // Create admin user
            $stmt = $pdo->prepare("
                INSERT INTO users (username, email, password_hash, full_name, role) 
                VALUES ('admin', 'admin@example.com', ?, 'System Administrator', 'admin')
            ");
            $stmt->execute([$hash]);
            echo "✓ Admin user created successfully!\n";
        }
        
        echo "\nLogin Credentials:\n";
        echo "  Username: admin\n";
        echo "  Password: {$newPassword}\n";
        echo "\n⚠️  IMPORTANT: Change this password after first login!\n\n";
        
        return true;
    } catch (PDOException $e) {
        echo "✗ Error: " . $e->getMessage() . "\n";
        return false;
    }
}

// Function to generate password hash
function generateHash($password) {
    $hash = password_hash($password, PASSWORD_DEFAULT);
    echo "Password: {$password}\n";
    echo "Hash: {$hash}\n\n";
    echo "To use in SQL:\n";
    echo "UPDATE users SET password_hash = '{$hash}' WHERE username = 'admin';\n\n";
}

// Main menu
echo "Choose an option:\n";
echo "1. Reset admin password to: Admin123!\n";
echo "2. Reset admin password (custom)\n";
echo "3. Generate password hash only\n";
echo "4. Exit\n\n";
echo "Enter option (1-4): ";

$handle = fopen("php://stdin", "r");
$option = trim(fgets($handle));

switch ($option) {
    case '1':
        echo "\nResetting admin password to 'Admin123!'...\n";
        resetAdminPassword($pdo, 'Admin123!');
        break;
        
    case '2':
        echo "\nEnter new password: ";
        $password = trim(fgets($handle));
        if (strlen($password) < 8) {
            echo "✗ Password must be at least 8 characters!\n";
            break;
        }
        echo "Confirm password: ";
        $confirm = trim(fgets($handle));
        if ($password !== $confirm) {
            echo "✗ Passwords do not match!\n";
            break;
        }
        echo "\nResetting admin password...\n";
        resetAdminPassword($pdo, $password);
        break;
        
    case '3':
        echo "\nEnter password to hash: ";
        $password = trim(fgets($handle));
        echo "\nGenerating hash...\n\n";
        generateHash($password);
        break;
        
    case '4':
        echo "Goodbye!\n";
        exit(0);
        
    default:
        echo "Invalid option!\n";
}

fclose($handle);
?>
