# Risk System - Quick Start

## 📦 Archive Name: `risk-system.tar.gz`
## 📁 Folder Name: `risk-system`

## Quick Installation

```bash
# Extract archive
tar -xzf risk-system.tar.gz

# Navigate to folder
cd risk-system

# Upload to your web server
# Point document root to: /path/to/risk-system/public/
```

## Directory Structure

```
risk-system/
├── public/              ← Web server document root
│   ├── *.php           ← Application pages
│   ├── css/
│   ├── js/
│   └── api/
├── includes/            ← Not web accessible
│   ├── config.php
│   └── schema.sql
├── templates/           ← Not web accessible
├── uploads/             ← Photo storage
│   └── photos/
├── reports/             ← PDF storage
└── *.md                 ← Documentation
```

## Web Server Configuration

### Apache Virtual Host

```apache
<VirtualHost *:80>
    ServerName your-domain.com
    DocumentRoot /var/www/html/risk-system/public
    
    <Directory /var/www/html/risk-system/public>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

### Nginx

```nginx
server {
    listen 80;
    server_name your-domain.com;
    root /var/www/html/risk-system/public;
    index index.php;
    
    location ~ \.php$ {
        include snippets/fastcgi-php.conf;
        fastcgi_pass unix:/var/run/php/php7.4-fpm.sock;
    }
}
```

## Database Setup

```bash
# Create database
mysql -u scubatricky_risk -p -e "CREATE DATABASE scubatricky_risk"

# Import schema
mysql -u scubatricky_risk -p scubatricky_risk < includes/schema.sql

# Edit config
nano includes/config.php
```

## Default Login

- **Username**: `admin`
- **Password**: `Admin123!`

**Change password immediately after first login!**

## File Permissions

```bash
# Set ownership
sudo chown -R www-data:www-data risk-system/

# Set directory permissions
find risk-system -type d -exec chmod 755 {} \;

# Set file permissions
find risk-system -type f -exec chmod 644 {} \;

# Make writable directories
chmod 775 risk-system/reports
chmod 775 risk-system/uploads/photos
```

## Documentation

- **README.md** - Complete feature overview
- **DEPLOYMENT.md** - Detailed deployment guide
- **DIRECTORY_STRUCTURE.md** - Web server configuration
- **LOGIN_TROUBLESHOOTING.md** - Password reset help
- **CUSTOM_FIELDS_GUIDE.md** - Custom fields documentation
- **PHOTO_UPLOAD_GUIDE.md** - Photo upload feature guide
- **FORM_ERRORS.md** - Form troubleshooting

## Key Features

✅ Risk Assessment Management
✅ Location Management with Maps
✅ Custom Fields System
✅ Photo Upload with Captions
✅ User Management
✅ PDF Report Generation
✅ Offline PWA Support
✅ Role-Based Access Control

## Need Help?

Check the documentation files or:
- Review browser console (F12)
- Check server error logs
- Verify file permissions
- Test database connection

---

**Folder renamed from `risk-assessment-app` to `risk-system`**
