# Deployment Checklist - Risk Assessment System

## Pre-Deployment

### Server Requirements
- [ ] PHP 7.4+ installed with required extensions (PDO, pdo_mysql, json, mbstring, session)
- [ ] MySQL 5.7+ or MariaDB 10.3+ installed and running
- [ ] Python 3.7+ installed
- [ ] Apache/Nginx web server configured
- [ ] SSL certificate installed (for HTTPS - required for PWA)
- [ ] Sufficient disk space (minimum 500MB)

### Security Preparations
- [ ] Server firewall configured
- [ ] SSH key authentication enabled
- [ ] Root login disabled
- [ ] Non-root user created for deployment
- [ ] Database user with limited privileges prepared
- [ ] Strong passwords generated for all accounts

## Deployment Steps

### 1. File Upload
- [ ] Upload all files to server
- [ ] Set correct ownership: `chown -R www-data:www-data /path/to/app`
- [ ] Set correct permissions: `chmod -R 755 /path/to/app`
- [ ] Make reports/ writable: `chmod 755 reports/`
- [ ] Make Python script executable: `chmod +x public/api/generate_pdf.py`

### 2. Database Setup
- [ ] Create database with UTF-8 encoding
- [ ] Create dedicated database user with strong password
- [ ] Grant necessary privileges to database user
- [ ] Import schema.sql
- [ ] Verify default admin account exists
- [ ] Test database connection

### 3. Configuration
- [ ] Update `includes/config.php` with production settings:
  - [ ] Database credentials
  - [ ] Site URL (with HTTPS)
  - [ ] Session security settings (set cookie_secure to 1)
- [ ] Configure upload paths
- [ ] Set correct timezone in PHP
- [ ] Disable PHP error display (display_errors = Off)
- [ ] Enable PHP error logging

### 4. Web Server Configuration

#### Apache
- [ ] Configure virtual host
- [ ] Enable mod_rewrite
- [ ] Enable mod_headers
- [ ] Configure .htaccess
- [ ] Set up SSL/TLS
- [ ] Test HTTPS redirect

#### Nginx
- [ ] Configure server block
- [ ] Set up PHP-FPM
- [ ] Configure SSL/TLS
- [ ] Set up security headers
- [ ] Test configuration: `nginx -t`
- [ ] Reload Nginx: `systemctl reload nginx`

### 5. Python Dependencies
- [ ] Install ReportLab: `pip3 install reportlab --break-system-packages`
- [ ] Test Python script: `python3 public/api/generate_pdf.py`
- [ ] Verify Python can write to reports/ directory

### 6. Security Hardening
- [ ] Change default admin password
- [ ] Remove or rename install.php (or protect with password)
- [ ] Review and update .htaccess security rules
- [ ] Verify includes/ directory is not web-accessible
- [ ] Verify reports/ directory is not directly accessible
- [ ] Enable HTTPS-only cookies
- [ ] Configure Content Security Policy (CSP)
- [ ] Set up fail2ban for login protection (optional)

### 7. Performance Optimization
- [ ] Enable PHP opcache
- [ ] Configure MySQL query cache
- [ ] Enable gzip/deflate compression
- [ ] Set up browser caching headers
- [ ] Optimize MySQL configuration
- [ ] Consider CDN for static assets (optional)

### 8. Backup Setup
- [ ] Configure automated database backups
- [ ] Set up file system backups
- [ ] Test backup restoration process
- [ ] Store backups in secure location
- [ ] Document backup schedule

### 9. Monitoring
- [ ] Set up server monitoring (CPU, RAM, disk)
- [ ] Configure MySQL monitoring
- [ ] Set up log rotation
- [ ] Configure error alerting
- [ ] Test monitoring alerts

## Post-Deployment

### Testing
- [ ] Test login functionality
- [ ] Create test assessment
- [ ] Test PDF generation
- [ ] Test offline mode
- [ ] Test on mobile devices
- [ ] Test all user roles (admin, assessor, viewer)
- [ ] Test photo upload
- [ ] Test data export
- [ ] Verify email notifications work (if configured)

### Documentation
- [ ] Document server configuration
- [ ] Document backup procedures
- [ ] Document restore procedures
- [ ] Create user guides
- [ ] Document API endpoints (if any)
- [ ] Create admin procedures

### User Setup
- [ ] Change default admin password
- [ ] Create admin accounts for team
- [ ] Create assessor accounts
- [ ] Create viewer accounts (if needed)
- [ ] Set up user permissions
- [ ] Train users on system

### Maintenance Plan
- [ ] Schedule regular backups
- [ ] Plan for updates and patches
- [ ] Schedule security audits
- [ ] Plan capacity monitoring
- [ ] Schedule database optimization
- [ ] Plan for disaster recovery

## Production Checklist

### Critical Settings
- [ ] `display_errors = Off` in php.ini
- [ ] `log_errors = On` in php.ini
- [ ] Error logs configured and monitored
- [ ] Session security enabled (HTTPS cookies)
- [ ] CSRF protection active
- [ ] SQL injection prevention (using PDO prepared statements)
- [ ] XSS prevention active
- [ ] File upload restrictions in place

### Performance Settings
- [ ] PHP opcache enabled
- [ ] MySQL query cache enabled
- [ ] Gzip compression enabled
- [ ] Browser caching configured
- [ ] Static asset optimization
- [ ] Database indexes optimized

### Security Settings
- [ ] HTTPS enforced site-wide
- [ ] Security headers configured
- [ ] Directory listing disabled
- [ ] Sensitive directories protected
- [ ] Strong password policy enforced
- [ ] Session timeout configured
- [ ] Failed login tracking enabled

## Final Verification

- [ ] Site accessible via HTTPS
- [ ] All features working correctly
- [ ] No PHP errors in logs
- [ ] No JavaScript errors in console
- [ ] PWA installation works
- [ ] Offline mode functional
- [ ] PDF generation working
- [ ] Database backups running
- [ ] Monitoring active
- [ ] Documentation complete

## Rollback Plan

In case of issues:
1. [ ] Keep previous version files available
2. [ ] Database backup immediately before deployment
3. [ ] Document rollback steps
4. [ ] Test rollback procedure
5. [ ] Have database restore script ready

## Sign-off

- [ ] Deployed by: _________________ Date: _______
- [ ] Tested by: _________________ Date: _______
- [ ] Approved by: _________________ Date: _______

---

**Note**: Keep this checklist for future deployments and updates!
