# Database Setup Guide

## Database Credentials

**Database Name:** `scubatricky_risk`  
**Database User:** `scubatricky_risk`  
**Database Password:** (Set by you during installation)

## Quick Setup

### Option 1: Using MySQL Command Line

```bash
# Connect to MySQL
mysql -u scubatricky_risk -p

# Create database
CREATE DATABASE scubatricky_risk CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

# Grant privileges (if user already exists)
GRANT ALL PRIVILEGES ON scubatricky_risk.* TO 'scubatricky_risk'@'localhost';
FLUSH PRIVILEGES;

# Exit MySQL
exit;

# Import schema
mysql -u scubatricky_risk -p scubatricky_risk < includes/schema.sql
```

### Option 2: If User Doesn't Exist Yet

```bash
# Connect as root to create user
mysql -u root -p

# Create database
CREATE DATABASE scubatricky_risk CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

# Create user with password (change 'your_password')
CREATE USER 'scubatricky_risk'@'localhost' IDENTIFIED BY 'your_password';

# Grant all privileges
GRANT ALL PRIVILEGES ON scubatricky_risk.* TO 'scubatricky_risk'@'localhost';

# Apply privileges
FLUSH PRIVILEGES;

# Exit
exit;

# Import schema with new user
mysql -u scubatricky_risk -p scubatricky_risk < includes/schema.sql
```

## Configuration File

Update `includes/config.php`:

```php
<?php
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'scubatricky_risk');
define('DB_PASS', 'your_password_here');  // Set your password
define('DB_NAME', 'scubatricky_risk');
```

## Python PDF Generator

The Python script is already configured for the database.

File: `public/api/generate_pdf_enhanced.py`

```python
DB_CONFIG = {
    'host': 'localhost',
    'database': 'scubatricky_risk',
    'user': 'scubatricky_risk',
    'password': ''  # Add password if needed
}
```

## Migration Files

All migration files use the correct database name:

```bash
# Run migrations
mysql -u scubatricky_risk -p scubatricky_risk < includes/migration_add_custom_fields.sql
mysql -u scubatricky_risk -p scubatricky_risk < includes/migration_add_location_fields.sql
mysql -u scubatricky_risk -p scubatricky_risk < includes/migration_photos_enhanced.sql
mysql -u scubatricky_risk -p scubatricky_risk < includes/migration_vehicle_types.sql
mysql -u scubatricky_risk -p scubatricky_risk < includes/migration_pdf_templates.sql
mysql -u scubatricky_risk -p scubatricky_risk < includes/migration_version_control.sql
```

## cPanel Setup

### Step 1: Create Database

1. Login to cPanel
2. Go to **MySQL® Databases**
3. Create New Database:
   - Name: `scubatricky_risk`
   - Click "Create Database"

### Step 2: Create/Use User

1. In **MySQL® Databases**
2. If user `scubatricky_risk` exists:
   - Scroll to "Add User To Database"
   - Select user: `scubatricky_risk`
   - Select database: `scubatricky_risk`
   - Click "Add"
   - Select "ALL PRIVILEGES"
   - Click "Make Changes"

3. If user doesn't exist:
   - Create New User: `scubatricky_risk`
   - Set strong password
   - Click "Create User"
   - Then follow step 2 to add to database

### Step 3: Import Schema

1. Go to **phpMyAdmin**
2. Select `scubatricky_risk` database
3. Click **Import** tab
4. Choose file: `includes/schema.sql`
5. Click **Go**

### Step 4: Update Config

1. Edit `includes/config.php` via File Manager or FTP
2. Update credentials:
   ```php
   define('DB_USER', 'scubatricky_risk');
   define('DB_PASS', 'your_actual_password');
   define('DB_NAME', 'scubatricky_risk');
   ```

## Remote Database (Optional)

If database is on remote server:

```php
// In config.php
define('DB_HOST', 'remote.server.com');  // Change from localhost
define('DB_USER', 'scubatricky_risk');
define('DB_PASS', 'your_password');
define('DB_NAME', 'scubatricky_risk');
```

## Testing Connection

Create `test-db.php` in public folder:

```php
<?php
require_once '../includes/config.php';

try {
    $stmt = $pdo->query("SELECT COUNT(*) FROM users");
    $count = $stmt->fetchColumn();
    echo "✅ Database connected successfully!<br>";
    echo "Found $count users in database.";
} catch (Exception $e) {
    echo "❌ Database connection failed:<br>";
    echo $e->getMessage();
}
```

Visit: `http://your-domain.com/test-db.php`

**Delete this file after testing!**

## Troubleshooting

### "Access denied for user"

**Cause:** Wrong password or user doesn't have privileges

**Fix:**
```bash
mysql -u root -p

GRANT ALL PRIVILEGES ON scubatricky_risk.* TO 'scubatricky_risk'@'localhost';
FLUSH PRIVILEGES;
```

### "Unknown database"

**Cause:** Database doesn't exist

**Fix:**
```bash
mysql -u root -p

CREATE DATABASE scubatricky_risk CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### "Can't connect to MySQL server"

**Cause:** MySQL not running or wrong host

**Fix:**
```bash
# Check MySQL status
sudo systemctl status mysql

# Start MySQL
sudo systemctl start mysql

# Check host in config.php (should be 'localhost' or '127.0.0.1')
```

### Python Script Can't Connect

**Update password in Python script:**

Edit `public/api/generate_pdf_enhanced.py`:

```python
DB_CONFIG = {
    'host': 'localhost',
    'database': 'scubatricky_risk',
    'user': 'scubatricky_risk',
    'password': 'your_password_here'  # Add password
}
```

## Backup & Restore

### Backup Database

```bash
# Full backup
mysqldump -u scubatricky_risk -p scubatricky_risk > backup_$(date +%Y%m%d).sql

# Backup structure only
mysqldump -u scubatricky_risk -p --no-data scubatricky_risk > structure.sql

# Backup data only
mysqldump -u scubatricky_risk -p --no-create-info scubatricky_risk > data.sql
```

### Restore Database

```bash
# Restore from backup
mysql -u scubatricky_risk -p scubatricky_risk < backup_20260107.sql
```

## Security Recommendations

### 1. Strong Password

Use a strong password for database user:
- Minimum 16 characters
- Mix of upper/lowercase, numbers, symbols
- Not based on dictionary words

### 2. Restrict Database User

```sql
-- Only allow specific operations (example)
REVOKE ALL PRIVILEGES ON scubatricky_risk.* FROM 'scubatricky_risk'@'localhost';
GRANT SELECT, INSERT, UPDATE, DELETE ON scubatricky_risk.* TO 'scubatricky_risk'@'localhost';
FLUSH PRIVILEGES;
```

### 3. Localhost Only

Ensure user can only connect from localhost:
```sql
-- Check existing users
SELECT user, host FROM mysql.user WHERE user='scubatricky_risk';

-- Should show: scubatricky_risk | localhost
```

### 4. Secure Config File

```bash
# Protect config.php
chmod 640 includes/config.php
chown www-data:www-data includes/config.php
```

## Database Maintenance

### Optimize Tables

```sql
-- Connect to database
mysql -u scubatricky_risk -p scubatricky_risk

-- Optimize all tables
OPTIMIZE TABLE assessments, assessment_details, locations, users, photos;
```

### Check Database Size

```sql
SELECT 
    table_name,
    ROUND(((data_length + index_length) / 1024 / 1024), 2) AS "Size (MB)"
FROM information_schema.tables
WHERE table_schema = 'scubatricky_risk'
ORDER BY (data_length + index_length) DESC;
```

### Repair Tables

```sql
REPAIR TABLE assessments;
REPAIR TABLE assessment_details;
```

## Summary

**All database references now use:**
- Database Name: `scubatricky_risk`
- Username: `scubatricky_risk`
- Password: (Set by you)

**Files Updated:**
- ✅ `includes/config.php`
- ✅ All SQL migration files
- ✅ Python PDF generator
- ✅ All documentation
- ✅ Install instructions

**Ready to use!** 🚀
